/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.desktop.DesktopFrame;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.exception.PermissionException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.ServerException;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public abstract class DesktopTask
implements Runnable {
    private static DecimalFormat integerTimeFormatter = new DecimalFormat("00");
    private static final int PROGRESS_DIALOG_DELAY = 2000;
    private static final int PROGRESS_CHECK_DELAY = 1000;
    private static final int PROGRESS_CANCEL_DELAY = 30000;
    private JDialog progressDialog;
    protected Object result = null;
    protected Exception exception = null;
    private final JTextField elapsedText = new JTextField();
    private final JTextField stepText = new JTextField();
    private final JTextField totalText = new JTextField();
    private final JLabel elapsedLabel = new JLabel();
    private final JLabel stepLabel = new JLabel();
    private final JLabel totalLabel = new JLabel();
    private long elapsedSeconds = 0L;
    protected String taskTitle = null;
    private Window window;
    final JProgressBar progress = new JProgressBar();

    private void createProgressDialog(Window wnd, String title, String msg) {
        this.progressDialog = wnd instanceof Dialog ? new JDialog((Dialog)wnd, title, true) : new JDialog((Frame)wnd, title, true);
        this.progress.setIndeterminate(true);
        this.progress.setStringPainted(false);
        Container cp = this.progressDialog.getContentPane();
        cp.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(20, 10, 10, 15);
        mainPanel.add((Component)new JLabel(msg), c);
        this.elapsedText.setFont(new Font("Monospaced", 0, 12));
        this.elapsedText.setEditable(false);
        this.elapsedText.setHorizontalAlignment(4);
        this.elapsedLabel.setText(LNG.get((String)"UTIL_ELAPSED_TIME"));
        this.totalText.setFont(new Font("Monospaced", 0, 12));
        this.totalText.setEditable(false);
        this.totalText.setHorizontalAlignment(4);
        this.totalLabel.setText(LNG.get((String)"UTIL_TOTAL_TIME"));
        this.stepText.setFont(new Font("Monospaced", 0, 12));
        this.stepText.setEditable(false);
        this.stepText.setText("");
        this.stepLabel.setText(LNG.get((String)"UTIL_STEP_TEXT"));
        JComponent[][] components = new JComponent[][]{{this.elapsedLabel, this.elapsedText, null}, {this.totalLabel, this.totalText, null}, {this.stepLabel, this.stepText, null}};
        JPanel timePanel = GUIUtils.createBasicGridPanel((JComponent[][])components);
        timePanel.setBorder(BorderFactory.createBevelBorder(1));
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(5, 10, 5, 5);
        mainPanel.add((Component)timePanel, c);
        c.gridy = 2;
        c.insets = new Insets(10, 10, 5, 5);
        c.anchor = 10;
        mainPanel.add((Component)this.progress, c);
        cp.add((Component)mainPanel, "Center");
        this.progressDialog.setDefaultCloseOperation(0);
        this.progressDialog.setResizable(false);
        this.progressDialog.pack();
        Dimension wSize = this.progressDialog.getSize();
        Dimension sSize = Toolkit.getDefaultToolkit().getScreenSize();
        int newX = (sSize.width - wSize.width) / 3;
        int newY = (sSize.height - wSize.height) / 2;
        this.setStepText(null);
        this.setUnknownStatus();
        this.progressDialog.setLocation(newX, newY);
    }

    protected abstract void performTask() throws Exception;

    @Override
    public void run() {
        try {
            this.performTask();
        }
        catch (PermissionException pe) {
            this.exception = null;
            SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    String msg = LNG.get((String)"desktop.msg.permissionfailure");
                    StandardDialogs.showInfoDialog((Component)DesktopTask.this.window, (String)DesktopTask.this.taskTitle, (Object)msg);
                }
            });
        }
        catch (ServerException se) {
            ClientRemoteMonitor.getInstance().invalidate();
            this.exception = se;
        }
        catch (Exception e) {
            ClientRemoteMonitor.getInstance().invalidate();
            this.exception = e;
        }
        catch (Throwable t) {
            this.exception = new Exception(t);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    protected void setResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public boolean succeeded() {
        return this.exception == null;
    }

    public void setStepText(final String text) {
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (text == null) {
                    DesktopTask.this.stepLabel.setVisible(false);
                    DesktopTask.this.stepText.setVisible(false);
                    DesktopTask.this.stepText.setText("");
                } else {
                    DesktopTask.this.stepLabel.setVisible(true);
                    DesktopTask.this.stepText.setVisible(true);
                    DesktopTask.this.stepText.setText(text);
                }
                if (DesktopTask.this.progressDialog != null) {
                    DesktopTask.this.progressDialog.pack();
                }
            }
        });
    }

    public void setProgressStatus(final int perc) {
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DesktopTask.this.totalLabel.setVisible(true);
                DesktopTask.this.totalText.setVisible(true);
                DesktopTask.this.progress.setMinimum(0);
                DesktopTask.this.progress.setMaximum(100);
                DesktopTask.this.progress.setIndeterminate(false);
                DesktopTask.this.progress.setValue(perc);
                DesktopTask.this.progress.setStringPainted(true);
                int c = 200 - (int)(200.0 * (double)perc / 100.0);
                int b = 255 - (int)(150.0 * (double)perc / 100.0);
                DesktopTask.this.progress.setForeground(new Color(c, c, b));
                if (DesktopTask.this.progressDialog != null) {
                    DesktopTask.this.progressDialog.pack();
                }
            }
        });
    }

    public void setUnknownStatus() {
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DesktopTask.this.totalLabel.setVisible(false);
                DesktopTask.this.totalText.setVisible(false);
                DesktopTask.this.progress.setIndeterminate(true);
                DesktopTask.this.progress.setStringPainted(false);
                if (DesktopTask.this.progressDialog != null) {
                    DesktopTask.this.progressDialog.pack();
                }
            }
        });
    }

    private String timeFormat(long v) {
        return integerTimeFormatter.format(v);
    }

    private String secToString(long seconds) {
        if (seconds < 0L) {
            return "-";
        }
        long sec = seconds;
        long min = 0L;
        long hou = 0L;
        if (sec >= 60L) {
            min = (int)sec / 60;
            sec -= min * 60L;
        }
        if (min >= 60L) {
            hou = (int)min / 60;
            min -= hou * 60L;
        }
        return this.timeFormat(hou) + "h " + this.timeFormat(min) + "m " + this.timeFormat(sec) + "s";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Window parentWindow, String title, String taskMessage) {
        this.elapsedSeconds = 0L;
        this.taskTitle = title;
        this.window = parentWindow == null ? DesktopFrame.getInstance().getDesktopFrame() : parentWindow;
        try {
            this.window.setCursor(Cursor.getPredefinedCursor(3));
            final Thread worker = new Thread(this);
            worker.start();
            try {
                worker.join(2000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (!worker.isAlive()) {
                return;
            }
            this.createProgressDialog(this.window, title, taskMessage);
            Thread elapsedTimer = new Thread(){

                @Override
                public void run() {
                    while (worker.isAlive()) {
                        try {
                            SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    DesktopTask.this.elapsedText.setText(DesktopTask.this.secToString(DesktopTask.this.elapsedSeconds));
                                    if (DesktopTask.this.progress.isIndeterminate()) {
                                        DesktopTask.this.totalText.setText("???");
                                    } else {
                                        int perc = DesktopTask.this.progress.getValue();
                                        long es = DesktopTask.this.elapsedSeconds;
                                        long ts = -999L;
                                        if (perc != 0) {
                                            ts = (int)((double)es * 100.0 / (double)perc);
                                        }
                                        DesktopTask.this.totalText.setText(DesktopTask.this.secToString(ts));
                                    }
                                }
                            });
                            Thread.sleep(1000L);
                            DesktopTask.this.elapsedSeconds++;
                        }
                        catch (Throwable throwable) {}
                    }
                }
            };
            elapsedTimer.start();
            final Timer closeDialogTimer = new Timer(1000, null);
            closeDialogTimer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!worker.isAlive()) {
                        if (DesktopTask.this.progressDialog != null) {
                            DesktopTask.this.progressDialog.setVisible(false);
                            DesktopTask.this.progressDialog.dispose();
                        }
                        closeDialogTimer.stop();
                    }
                }
            });
            closeDialogTimer.start();
            Timer showCancelTimer = new Timer(30000, null);
            showCancelTimer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (worker.isAlive()) {
                        Container cp = DesktopTask.this.progressDialog.getContentPane();
                        JButton cancelButton = new JButton(LNG.get((String)"UTIL_CANCEL"));
                        cancelButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ev) {
                                try {
                                    worker.interrupt();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                DesktopTask.this.progressDialog.setVisible(false);
                                DesktopTask.this.progressDialog.dispose();
                                DesktopTask.this.exception = new Exception(LNG.get((String)"UTIL_USER_INTERRUPT"));
                            }
                        });
                        JPanel buttonPanel = new JPanel();
                        buttonPanel.add(cancelButton);
                        cp.add((Component)buttonPanel, "South");
                        cp.invalidate();
                        DesktopTask.this.progressDialog.pack();
                    }
                }
            });
            showCancelTimer.setRepeats(false);
            showCancelTimer.start();
            this.progressDialog.setVisible(true);
        }
        finally {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

