/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.desktop.RemoteTask;
import csbase.client.ias.AbstractPermissionPanel;
import csbase.client.ias.PermissionInfoDialog;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ChoicePermission;
import csbase.logic.Permission;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.selector.ContainerSelection;
import tecgraf.javautils.gui.selector.ContainerSelectionListener;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class ChoicePermissionPanel
extends AbstractPermissionPanel {
    AttributesNavigator navigator;
    private JLabel attributeName;
    private String attributeNameKey;
    private JComboBox attributeValue;
    private Map<String, Object> attributeRange;
    private Map<String, ArrayList<Object>> map;
    private ContainerSelection<String> containerSelection;
    String windowLabel;
    private JButton nextButton;
    private JButton previousButton;
    private JButton includePermissionButton;
    private boolean isNew = true;

    ChoicePermissionPanel(PermissionInfoDialog dialog, String windowLabel) {
        super((LayoutManager)new GridBagLayout(), dialog);
        this.windowLabel = windowLabel;
        this.map = new HashMap<String, ArrayList<Object>>();
        this.nextButton = dialog.nextButton = new JButton(LNG.get((String)"IAS_NEXT"));
        this.previousButton = dialog.previousButton = new JButton(LNG.get((String)"IAS_PREVIOUS"));
        this.includePermissionButton = dialog.includePermissionButton;
        this.navigator = new AttributesNavigator();
        dialog.nextButton.setVisible(false);
        dialog.nextButton.setEnabled(true);
        dialog.previousButton.setVisible(false);
        dialog.previousButton.setEnabled(true);
        dialog.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChoicePermissionPanel.this.navigator.next();
            }
        });
        dialog.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChoicePermissionPanel.this.navigator.previous();
            }
        });
        this.attributeName = new JLabel();
        this.attributeValue = new JComboBox();
        this.attributeValue.setSelectedIndex(-1);
        this.attributeValue.setVisible(false);
        this.attributeValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                if (ChoicePermissionPanel.this.attributeValue.getSelectedIndex() != -1) {
                    ArrayList value = new ArrayList();
                    value.add(ChoicePermissionPanel.this.attributeRange.get(ChoicePermissionPanel.this.attributeValue.getSelectedItem()));
                    ChoicePermissionPanel.this.map.put(ChoicePermissionPanel.this.attributeNameKey, value);
                    ChoicePermissionPanel.this.nextButton.setEnabled(true);
                    ChoicePermissionPanel.this.includePermissionButton.setEnabled(!ChoicePermissionPanel.this.nextButton.isVisible());
                } else {
                    ChoicePermissionPanel.this.nextButton.setEnabled(false);
                    ChoicePermissionPanel.this.includePermissionButton.setEnabled(false);
                }
                if (!ChoicePermissionPanel.this.isNew) {
                    ChoicePermissionPanel.this.dialog.checkDataChange();
                }
            }
        });
        this.containerSelection = new ContainerSelection((ObjectTableProvider)new TableItemsFormatter(), (ObjectTableProvider)new SelectedItemsFormatter(), true, false);
        this.containerSelection.adjustTableColumns();
        this.containerSelection.addContainerSelectionListener(new ContainerSelectionListener(){

            public void containerChanged() {
                List selectedItems = ChoicePermissionPanel.this.containerSelection.getSelectedItems();
                if (selectedItems.size() > 0) {
                    ArrayList values = new ArrayList();
                    for (int i = 0; i < selectedItems.size(); ++i) {
                        values.add(ChoicePermissionPanel.this.attributeRange.get(selectedItems.get(i)));
                    }
                    ChoicePermissionPanel.this.map.put(ChoicePermissionPanel.this.attributeNameKey, values);
                    ChoicePermissionPanel.this.nextButton.setEnabled(true);
                    ChoicePermissionPanel.this.includePermissionButton.setEnabled(!ChoicePermissionPanel.this.nextButton.isVisible());
                } else {
                    ChoicePermissionPanel.this.nextButton.setEnabled(false);
                    ChoicePermissionPanel.this.includePermissionButton.setEnabled(false);
                }
                if (!ChoicePermissionPanel.this.isNew) {
                    ChoicePermissionPanel.this.dialog.checkDataChange();
                }
            }
        });
        this.containerSelection.getPanel();
        GBC gbc = new GBC(0, 0).width(2).northwest().both().fillxy();
        this.add((Component)this.createChoicePermissionPanel(), gbc);
    }

    private JPanel createChoicePermissionPanel() {
        JPanel choicePermissionPanel = new JPanel(new GridBagLayout());
        GBC gbc = new GBC(0, 0).insets(5, 5, 5, 5);
        choicePermissionPanel.add((Component)this.attributeName, gbc);
        gbc = new GBC(1, 0).horizontal().insets(5, 5, 5, 5).fillxy();
        choicePermissionPanel.add((Component)this.attributeValue, gbc);
        gbc = new GBC(0, 0).both().insets(5, 5, 5, 5).fillxy();
        choicePermissionPanel.add((Component)this.containerSelection.getPanel(), gbc);
        return choicePermissionPanel;
    }

    @Override
    void importFrom(Permission permission) {
        this.isNew = false;
        this.map.putAll(((ChoicePermission)permission).getAttributes());
        this.navigator.init();
    }

    @Override
    void exportTo(Permission permission) {
        ((ChoicePermission)permission).setAttributes(this.map);
    }

    @Override
    void clearFields() {
        this.map.clear();
        this.navigator.rewind();
    }

    @Override
    boolean hasChanged(Permission permission) {
        return !((ChoicePermission)permission).getAttributes().equals(this.map);
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.includePermissionButton.setEnabled(!aFlag);
        if (aFlag) {
            this.navigator.init();
        } else {
            this.nextButton.setVisible(false);
            this.previousButton.setVisible(false);
        }
    }

    @Override
    public void changeClass() {
        super.changeClass();
        this.navigator.init();
    }

    private class AttributesNavigator {
        ArrayList<Map.Entry<String, Object>> domainList;
        int position;
        ChoicePermission choicePermission;
        Map<String, Map<String, Object>> domainAttributesRangeMap = new HashMap<String, Map<String, Object>>();

        private AttributesNavigator() {
        }

        public void init() {
            PermissionInfoDialog window = ChoicePermissionPanel.this.dialog;
            String windowLabel = ChoicePermissionPanel.this.windowLabel;
            PermissionInfoDialog.PermissionClassName item = ChoicePermissionPanel.this.dialog.getPermissionClassName();
            try {
                Class<?> selectedClass = Class.forName(item.getClassName());
                Constructor<?> constructor = selectedClass.getConstructor(new Class[0]);
                this.choicePermission = (ChoicePermission)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                StandardErrorDialogs.showErrorDialog((Window)window, LNG.get((String)"ERRO") + " - " + windowLabel, (Throwable)e);
            }
            RemoteTask<Void> task = new RemoteTask<Void>(){

                public void performTask() throws Exception {
                    Map domainMap = AttributesNavigator.this.choicePermission.getDomain();
                    AttributesNavigator.this.domainList = new ArrayList(domainMap.entrySet());
                    for (int i = 0; i < AttributesNavigator.this.domainList.size(); ++i) {
                        String attrName = AttributesNavigator.this.domainList.get(i).getKey();
                        AttributesNavigator.this.domainAttributesRangeMap.put(attrName, AttributesNavigator.this.choicePermission.getRange(attrName));
                    }
                }
            };
            if (!task.execute(window, LNG.get((String)"desktop.msg.wait"), LNG.get((String)"desktop.msg.wait"))) {
                this.domainList = new ArrayList();
                ChoicePermissionPanel.this.attributeName.setVisible(false);
                ChoicePermissionPanel.this.attributeValue.setVisible(false);
                ChoicePermissionPanel.this.containerSelection.getPanel().setVisible(false);
            }
            this.position = -1;
            this.next();
        }

        void previous() {
            if (this.position > 0) {
                --this.position;
                String key = this.domainList.get(this.position).getKey();
                ChoicePermissionPanel.this.attributeRange = this.domainAttributesRangeMap.get(key);
                this.go(key);
            }
        }

        void next() {
            if (this.domainList.size() - 1 > this.position) {
                ++this.position;
                String key = this.domainList.get(this.position).getKey();
                ChoicePermissionPanel.this.attributeRange = this.domainAttributesRangeMap.get(key);
                this.go(key);
            }
        }

        void rewind() {
            ChoicePermissionPanel.this.attributeValue.setSelectedIndex(-1);
            ChoicePermissionPanel.this.attributeValue.invalidate();
            this.position = -1;
            this.next();
        }

        void go(String key) {
            ChoicePermissionPanel.this.previousButton.setVisible(this.position > 0);
            ChoicePermissionPanel.this.nextButton.setVisible(this.domainList.size() - 1 > this.position);
            ChoicePermissionPanel.this.attributeNameKey = key;
            ChoicePermissionPanel.this.attributeName.setText(LNG.get((String)ChoicePermissionPanel.this.attributeNameKey));
            Boolean isMultiSelect = (Boolean)this.domainList.get(this.position).getValue();
            ArrayList mapValue = (ArrayList)ChoicePermissionPanel.this.map.get(key);
            if (isMultiSelect.booleanValue()) {
                ChoicePermissionPanel.this.attributeName.setVisible(false);
                ChoicePermissionPanel.this.attributeValue.setVisible(false);
                if (mapValue != null) {
                    ArrayList idList = mapValue;
                    Iterator keyIterator = ChoicePermissionPanel.this.attributeRange.keySet().iterator();
                    ArrayList<String> selectedItems = new ArrayList<String>();
                    block0: while (keyIterator.hasNext()) {
                        Object attributeKey = keyIterator.next();
                        for (int i = 0; i < idList.size(); ++i) {
                            if (!idList.get(i).equals(ChoicePermissionPanel.this.attributeRange.get(attributeKey))) continue;
                            selectedItems.add((String)attributeKey);
                            continue block0;
                        }
                    }
                    ChoicePermissionPanel.this.containerSelection.loadItems(ChoicePermissionPanel.this.attributeRange.keySet(), selectedItems);
                } else {
                    ChoicePermissionPanel.this.containerSelection.loadItems(ChoicePermissionPanel.this.attributeRange.keySet(), new ArrayList());
                }
                ChoicePermissionPanel.this.containerSelection.getPanel().setVisible(true);
            } else {
                ChoicePermissionPanel.this.containerSelection.getPanel().setVisible(false);
                ChoicePermissionPanel.this.attributeName.setVisible(true);
                ChoicePermissionPanel.this.attributeValue.setVisible(true);
                ChoicePermissionPanel.this.attributeValue.setModel(new DefaultComboBoxModel<Object>(ChoicePermissionPanel.this.attributeRange.keySet().toArray()));
                if (mapValue != null) {
                    Object attrValue = mapValue.get(0);
                    Object attrName = this.getAttributeName(attrValue);
                    ChoicePermissionPanel.this.attributeValue.setSelectedItem(attrName);
                } else {
                    ChoicePermissionPanel.this.attributeValue.setSelectedIndex(-1);
                }
            }
        }

        private Object getAttributeName(Object attrValue) {
            Set entries = ChoicePermissionPanel.this.attributeRange.entrySet();
            for (Map.Entry entry : entries) {
                if (!entry.getValue().equals(attrValue)) continue;
                return entry.getKey();
            }
            return null;
        }
    }

    class SelectedItemsFormatter
    extends DefaultObjectTableProvider {
        SelectedItemsFormatter() {
        }

        public String[] getColumnNames() {
            return new String[]{LNG.get((String)"IAS_SELECTED_ITEMS")};
        }

        public Class<?>[] getColumnClasses() {
            return new Class[]{String.class};
        }

        public Object[] getCellValues(Object arg0) {
            return new Object[]{arg0.toString()};
        }
    }

    class TableItemsFormatter
    extends DefaultObjectTableProvider {
        TableItemsFormatter() {
        }

        public String[] getColumnNames() {
            return new String[]{LNG.get((String)"IAS_AVAILABLE_ITEMS")};
        }

        public Class<?>[] getColumnClasses() {
            return new Class[]{String.class};
        }

        public Object[] getCellValues(Object arg0) {
            return new Object[]{arg0.toString()};
        }
    }
}

