/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.login;

import csbase.client.login.LocaleComboBoxItem;
import csbase.exception.ConfigurationException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.configurationmanager.MissingPropertyException;

final class LocaleComboBoxModel
implements ComboBoxModel {
    private static final int INVALID_INDEX = -1;
    private static final String DISPLAY_PROPERTY = "locale.display";
    private static final String PROGRAMMATIC_PROPERTY = "locale.programmatic";
    private static final String ADDITIONAL_DISPLAY_PROPERTY = "additional.locale.display";
    private static final String ADDITIONAL_PROGRAMMATIC_PROPERTY = "additional.locale.programmatic";
    private List<LocaleComboBoxItem> localeList;
    private LocaleComboBoxItem selectedLocale;
    private List<ListDataListener> listDataListenerList = new LinkedList<ListDataListener>();

    LocaleComboBoxModel() {
        int i;
        List programmaticList;
        List nameList;
        Configuration configuration;
        try {
            configuration = ConfigurationManager.getInstance().getConfiguration(LocaleComboBoxModel.class);
        }
        catch (ConfigurationManagerException e) {
            throw new ConfigurationException((Throwable)e);
        }
        try {
            nameList = configuration.getMandatoryListProperty(DISPLAY_PROPERTY);
            programmaticList = configuration.getMandatoryLocaleListProperty(PROGRAMMATIC_PROPERTY);
        }
        catch (MissingPropertyException e) {
            e.printStackTrace();
            throw new IllegalStateException("N\u00e3o foi definido nenhum idioma.");
        }
        List additionalNameList = configuration.getOptionalListProperty(ADDITIONAL_DISPLAY_PROPERTY);
        List additionalLanguageList = configuration.getOptionalLocaleListProperty(ADDITIONAL_PROGRAMMATIC_PROPERTY);
        this.localeList = new ArrayList<LocaleComboBoxItem>(nameList.size() + additionalNameList.size());
        for (i = 0; i < nameList.size(); ++i) {
            this.localeList.add(new LocaleComboBoxItem((String)nameList.get(i), (Locale)programmaticList.get(i)));
        }
        for (i = 0; i < additionalNameList.size(); ++i) {
            this.localeList.add(new LocaleComboBoxItem((String)additionalNameList.get(i), (Locale)additionalLanguageList.get(i)));
        }
        this.selectedLocale = this.localeList.get(0);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedLocale;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        int index = this.localeList.indexOf(anItem);
        if (index == -1) {
            throw new IllegalArgumentException("O item n\u00e3o existe no modelo.");
        }
        this.selectedLocale = this.localeList.get(index);
        this.fireContentsChanged(-1, -1);
    }

    private void fireContentsChanged(int firstIndex, int lastIndex) {
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, firstIndex, lastIndex);
        for (ListDataListener listDataListener : this.listDataListenerList) {
            listDataListener.contentsChanged(listDataEvent);
        }
    }

    @Override
    public int getSize() {
        return this.localeList.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.localeList.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        if (listDataListener == null) {
            throw new IllegalArgumentException("O ouvinte n\u00e3o pode ser nulo.");
        }
        this.listDataListenerList.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        if (listDataListener == null) {
            throw new IllegalArgumentException("O ouvinte n\u00e3o pode ser nulo.");
        }
        this.listDataListenerList.remove(listDataListener);
    }
}

