/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.ProjectFileNameAndTypeFilter;
import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectFileChooser;
import csbase.client.project.ProjectTreePath;
import csbase.client.project.tasks.GetChildFromNameTask;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileFilter;
import csbase.logic.ProjectFileType;
import csbase.logic.filters.ProjectFileCompositeOrFilter;
import csbase.logic.filters.ProjectFileDirectoryFilter;
import csbase.logic.filters.ProjectFileNotDirectoryFilter;
import csbase.logic.filters.ProjectFileTypeFilter;
import java.awt.Component;
import java.awt.Window;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public final class ProjectFileChooserSave
extends ProjectFileChooser {
    private static final String TITLE = LNG.get((String)"PRJ_FILE_CHOOSER_SAVE_TITLE");
    private final String forceExtension;

    public ProjectFileChooserSave(Window owner, CommonClientProject project, int mode) throws ClientException {
        this(owner, project, mode, null, null, null, false);
    }

    public ProjectFileChooserSave(Window owner, CommonClientProject project, int mode, String defaultFileType) throws ClientException {
        this(owner, project, mode, defaultFileType, null, null, false);
    }

    public ProjectFileChooserSave(Window owner, CommonClientProject project, int mode, String defaultFileType, String defaultName, String fileExtension, boolean useFilter) throws ClientException {
        this(owner, project, mode, new String[]{defaultFileType}, defaultFileType, defaultName, fileExtension, useFilter);
    }

    public ProjectFileChooserSave(Window owner, CommonClientProject project, int mode, String defaultFileType, String defaultName, String[] currentDirectory, String fileExtension, boolean useFilter) throws ClientException {
        this(owner, project, mode, new String[]{defaultFileType}, defaultFileType, defaultName, currentDirectory, fileExtension, useFilter);
    }

    public ProjectFileChooserSave(Window owner, CommonClientProject project, int mode, String[] fileTypes, String defaultFileType, String defaultName, String fileExtension, boolean useFilter) throws ClientException {
        this(owner, project, mode, fileTypes, defaultFileType, defaultName, null, fileExtension, useFilter);
    }

    public ProjectFileChooserSave(Window owner, CommonClientProject project, int mode, String[] fileTypes, String defaultFileType, String defaultName, String[] currentDirectory, String fileExtension, boolean useFilter) throws ClientException {
        super(owner, TITLE, project, false, mode, defaultFileType, ProjectFileChooserSave.getFilter(mode, fileTypes), ProjectFileChooserSave.getFilter(mode, fileTypes), true, defaultName, currentDirectory, useFilter);
        if (mode == 2) {
            throw new IllegalArgumentException("Erro: ProjectFileChooserSave n\u00e3o deve ser usado com modo = FILE_AND_DIRECTORY");
        }
        this.forceExtension = fileExtension;
        this.dialog.setVisible(true);
    }

    private static ProjectFileFilter getFilter(int mode, String[] fileTypes) {
        ProjectFileCompositeOrFilter projectFileCompositeFilter = new ProjectFileCompositeOrFilter();
        projectFileCompositeFilter.addChild((ProjectFileFilter)ProjectFileDirectoryFilter.getInstance());
        if (mode == 0 || mode == 2) {
            if (fileTypes == null || fileTypes.length == 0) {
                projectFileCompositeFilter.addChild((ProjectFileFilter)ProjectFileNotDirectoryFilter.getInstance());
            } else {
                projectFileCompositeFilter.addChild((ProjectFileFilter)new ProjectFileTypeFilter(fileTypes));
            }
        }
        return projectFileCompositeFilter;
    }

    @Override
    protected ProjectFileFilter getVisualFilter() {
        return ProjectFileChooserSave.getFilter(this.mode, null);
    }

    @Override
    protected ProjectFileFilter getVisualFilter(String fileType) {
        return ProjectFileChooserSave.getFilter(this.mode, new String[]{fileType});
    }

    @Override
    protected ProjectFileFilter getVisualFilter(String nameFilter, String fileType) {
        if (nameFilter == null || nameFilter.isEmpty()) {
            return this.getVisualFilter(fileType);
        }
        ProjectFileCompositeOrFilter projectFileCompositeFilter = new ProjectFileCompositeOrFilter();
        projectFileCompositeFilter.addChild((ProjectFileFilter)ProjectFileDirectoryFilter.getInstance());
        if (this.mode == 0 || this.mode == 2) {
            projectFileCompositeFilter.addChild((ProjectFileFilter)new ProjectFileNameAndTypeFilter(nameFilter, fileType));
        }
        return projectFileCompositeFilter;
    }

    @Override
    protected ProjectFileFilter getSelectionFilter() {
        return ProjectFileChooserSave.getFilter(this.mode, null);
    }

    @Override
    protected ProjectFileFilter getSelectionFilter(String fileType) {
        return ProjectFileChooserSave.getFilter(this.mode, new String[]{fileType});
    }

    @Override
    protected ProjectFileFilter getSelectionFilter(String nameFilter, String fileType) {
        if (nameFilter == null || nameFilter.isEmpty()) {
            return this.getSelectionFilter(fileType);
        }
        ProjectFileCompositeOrFilter projectFileCompositeFilter = new ProjectFileCompositeOrFilter();
        projectFileCompositeFilter.addChild((ProjectFileFilter)ProjectFileDirectoryFilter.getInstance());
        if (this.mode == 0 || this.mode == 2) {
            projectFileCompositeFilter.addChild((ProjectFileFilter)new ProjectFileNameAndTypeFilter(nameFilter, fileType));
        }
        return projectFileCompositeFilter;
    }

    @Override
    protected boolean handleAction() {
        ClientProjectFile selectedFile = this.getSelectedFile();
        if (this.mode == 1) {
            this.setSelection(selectedFile);
            return true;
        }
        String name = this.fileNameText.getText().trim();
        if (!ClientUtilities.isValidFileName(name)) {
            this.showFilenameError();
            return false;
        }
        ClientProjectFile targetDirectory = selectedFile.isDirectory() ? selectedFile : selectedFile.getParent();
        ClientProjectFile newFile = null;
        if (this.forceExtension != null) {
            name = FileUtils.addFileExtension((String)name, (String)this.forceExtension);
        }
        if ((newFile = GetChildFromNameTask.runTask(targetDirectory, name)) != null) {
            if (newFile.isDirectory()) {
                this.projectTree.setSelectedFile(newFile);
                return false;
            }
            if (this.confirmOverwrite(newFile)) {
                this.setSelection(newFile);
                return true;
            }
            return false;
        }
        this.setSelection(targetDirectory, name);
        return true;
    }

    private void setSelection(ClientProjectFile file) {
        this.selectedPaths = new ProjectTreePath[1];
        this.selectedPaths[0] = file != null ? new ProjectTreePath(file) : null;
    }

    private void setSelection(ClientProjectFile targetDirectory, String filename) {
        String[] dirPath = targetDirectory.getPath();
        String[] newPath = new String[dirPath.length + 1];
        System.arraycopy(dirPath, 0, newPath, 0, dirPath.length);
        newPath[newPath.length - 1] = filename;
        this.selectedPaths = new ProjectTreePath[1];
        this.selectedPaths[0] = new ProjectTreePath(newPath, targetDirectory);
    }

    private void showFilenameError() {
        StandardErrorDialogs.showErrorDialog((Window)this.dialog, TITLE, LNG.get((String)"PRJ_PROJECT_FILE_NAME_CHARACTERES_ERROR"));
    }

    private boolean confirmOverwrite(ClientProjectFile newFile) {
        if (newFile.isLocked()) {
            StandardDialogs.showErrorDialog((Component)this.dialog, (String)(LNG.get((String)"PRJ_FILE_CHOOSER_ERROR") + " - " + TITLE), (String)LNG.get((String)"PRJ_FILE_CHOOSER_OVERWRITE_LOCKED_FILE_ERROR"));
            return false;
        }
        int option = StandardDialogs.showYesNoDialog((Component)this.dialog, (String)(LNG.get((String)"PRJ_FILE_CHOOSER_INFO") + " - " + TITLE), (Object)LNG.get((String)"PRJ_FILE_CHOOSER_OVERWRITE_WARNING"));
        return option == 0;
    }

    public String getFileType() {
        Object selectedFileType = this.fileTypeList.getSelectedItem();
        if (selectedFileType instanceof String) {
            return ProjectFileType.getFileType((String)"UNKNOWN").getCode();
        }
        return ((ProjectFileType)selectedFileType).getCode();
    }

    @Override
    protected void makeSelection(ClientProjectFile[] projectFileArray) {
        if (projectFileArray.length == 0) {
            this.fileNameText.setText("");
            this.selectedPaths = null;
        } else {
            ClientProjectFile selectedFile = projectFileArray[0];
            if (!selectedFile.isDirectory()) {
                this.fileNameText.setText(selectedFile.getName());
            }
            this.selectedPaths = new ProjectTreePath[]{new ProjectTreePath(selectedFile)};
        }
    }
}

