/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.action.CommonProjectAction;
import csbase.logic.ClientProjectFile;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class CommonFileDeleteAction
extends CommonProjectAction {
    private static final String ACTION_NAME = LNG.get((String)"PRJ_DELETE");

    public CommonFileDeleteAction(ProjectFileContainer container) {
        super(container);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String confirmation;
        String windowTitle;
        String nodeType;
        String name;
        ClientProjectFile[] candidateFiles = this.getSelectedFiles();
        if (candidateFiles == null || candidateFiles.length == 0) {
            return;
        }
        List<ClientProjectFile> files = this.filterParentDirs(candidateFiles);
        if (files.isEmpty()) {
            return;
        }
        Window owner = this.getWindow();
        for (ClientProjectFile file : files) {
            if (!file.isRoot()) continue;
            StandardDialogs.showErrorDialog((Component)owner, (String)LNG.get((String)"GENERIC.title.error"), (String)LNG.get((String)"PRJ_REMOVAL_ONLY_VIA_MENU"));
            return;
        }
        ClientProjectFile file0 = files.get(0);
        if (files.size() > 1) {
            name = LNG.get((String)"PRJ_MULT_SELECTION");
            nodeType = LNG.get((String)"PRJ_DIRS") + '/' + LNG.get((String)"PRJ_FILES");
            windowTitle = MessageFormat.format(LNG.get((String)"PRJ_PROJECT_MULT_FILE_REMOVAL_TITLE"), nodeType);
            confirmation = MessageFormat.format(LNG.get((String)"PRJ_PROJECT_MULT_FILE_REMOVAL_CONFIRMATION"), nodeType);
        } else {
            name = file0.getName();
            if (!file0.isDirectory()) {
                nodeType = LNG.get((String)"PRJ_FILE");
                windowTitle = MessageFormat.format(LNG.get((String)"PRJ_PROJECT_FILE_REMOVAL_TITLE"), nodeType);
                confirmation = file0.isUnderConstruction() ? MessageFormat.format(LNG.get((String)"PRJ_PROJECT_FILE_UNDERCONSTRUCTION"), nodeType, name) : "";
                confirmation = confirmation + MessageFormat.format(LNG.get((String)"PRJ_PROJECT_FILE_REMOVAL_CONFIRMATION"), nodeType, name);
            } else {
                nodeType = LNG.get((String)"PRJ_DIRECTORY");
                windowTitle = MessageFormat.format(LNG.get((String)"PRJ_PROJECT_FILE_REMOVAL_TITLE"), nodeType);
                ClientProjectFile f = file0;
                confirmation = !f.hasChildren() ? MessageFormat.format(LNG.get((String)"PRJ_PROJECT_FILE_REMOVAL_CONFIRMATION"), nodeType, name) : MessageFormat.format(LNG.get((String)"PRJ_PROJECT_FILE_REMOVAL_CONFIRMATION"), nodeType, name) + '\n' + MessageFormat.format(LNG.get((String)"PRJ_PROJECT_DIRECTORY_FILES_WILL_BE_REMOVED"), name);
            }
        }
        Object[] options = new Object[]{LNG.get((String)"PRJ_REMOVAL"), LNG.get((String)"PRJ_CANCEL")};
        int opt = StandardDialogs.showOptionDialog((Component)owner, (String)windowTitle, (Object)confirmation, (Object[])options);
        if (opt != 0) {
            return;
        }
        this.clearClipboard();
        RemoteTask<Void> task = this.createFileRemovalTask(files, owner);
        task.execute(owner, windowTitle, MessageFormat.format(LNG.get((String)"PRJ_WAITING_DELETE_FILE"), nodeType, name));
    }

    private RemoteTask<Void> createFileRemovalTask(final List<ClientProjectFile> files, Window owner) {
        return new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                int size = files.size();
                if (size == 1) {
                    ((ClientProjectFile)files.get(0)).remove();
                } else {
                    CommonFileDeleteAction.this.getProject().removeFiles(files);
                }
            }
        };
    }

    private List<ClientProjectFile> filterParentDirs(ClientProjectFile[] selectedFiles) {
        ArrayList<ClientProjectFile> files = new ArrayList<ClientProjectFile>();
        for (ClientProjectFile projectFile : selectedFiles) {
            files.add(projectFile);
        }
        return files;
    }

    @Override
    public String getName() {
        return ACTION_NAME;
    }
}

