/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.desktop.RemoteTask;
import csbase.client.externalresources.ExternalResources;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.action.CommonProjectAction;
import csbase.client.project.tasks.GetChildFromNameTask;
import csbase.client.remote.srvproxies.HttpProxy;
import csbase.client.remote.srvproxies.NotificationProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class CommonFileUploadAction
extends CommonProjectAction {
    private static final int BLOCK_SIZE = 102400;
    private ClientProjectFile dir;
    private boolean isFileFromTree;
    private ClientProjectFile importDir;

    public CommonFileUploadAction(ProjectFileContainer container) {
        super(container);
        this.isFileFromTree = true;
    }

    public CommonFileUploadAction(ProjectFileContainer container, ClientProjectFile file) {
        super(container);
        this.isFileFromTree = false;
        this.importDir = file;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ClientProjectFile clientProjectFile = this.dir = this.isFileFromTree ? this.getSelectedFile() : this.importDir;
        if (ExternalResources.getInstance().isEnabled()) {
            this.jnlpOpenBrowser();
        } else {
            this.transferFile();
        }
    }

    private void jnlpOpenBrowser() {
        try {
            CommonClientProject project = this.getProject();
            String addr = HttpProxy.getUploadURL(project.getId(), this.dir.getPath(), "UNKNOWN");
            URL url = new URL(addr);
            ExternalResources.getInstance().showDocument(url);
        }
        catch (Exception e) {
            this.showError(LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_URL_ERROR"), e);
        }
    }

    private void transferFile() {
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(this.getWindow());
        if (returnVal == 1) {
            return;
        }
        File fileChoosed = chooser.getSelectedFile();
        String fileName = fileChoosed.getName();
        if (!ClientUtilities.isValidFileName(fileName)) {
            this.showError(LNG.get((String)"PRJ_PROJECT_FILE_NAME_CHARACTERES_ERROR"));
            return;
        }
        ClientProjectFile child = GetChildFromNameTask.runTask(this.dir, fileName);
        if (child != null) {
            this.showError(LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_FILE_ERROR"));
            return;
        }
        ClientProjectFile newFile = this.createFile(fileName);
        if (newFile == null) {
            this.showError(LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_FILE_ERROR"));
            return;
        }
        new Uploader(fileChoosed, newFile).start();
        String msg = MessageFormat.format(LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_START"), fileName);
        StandardDialogs.showInfoDialog((Component)this.getWindow(), (String)LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_TITLE"), (Object)msg);
    }

    private ClientProjectFile createFile(final String fileName) {
        final CommonClientProject project = this.getProject();
        RemoteTask<ClientProjectFile> task = new RemoteTask<ClientProjectFile>(){

            public void performTask() throws Exception {
                String fileType = "UNKNOWN";
                ClientProjectFile createdFile = project.createAndWaitForFile(CommonFileUploadAction.this.dir, fileName, fileType);
                this.setResult(createdFile);
            }
        };
        String message = MessageFormat.format(LNG.get((String)"PRJ_WAITING_UPLOAD_FILE"), fileName);
        if (task.execute(this.getWindow(), this.getTitle(), message) && task.getResult() != null) {
            return (ClientProjectFile)task.getResult();
        }
        return null;
    }

    @Override
    protected void showError(String msg) {
        this.showError(LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_TITLE"), msg);
    }

    private void showError(String msg, Exception ex) {
        StandardErrorDialogs.showErrorDialog(this.getWindow(), LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_TITLE"), msg, ex);
    }

    @Override
    public String getName() {
        return LNG.get((String)"PRJ_UPLOAD_FILE");
    }

    private class Uploader
    extends Thread {
        private ClientProjectFile targetFile;
        private File sourceFile;

        public Uploader(File sourceFile, ClientProjectFile targetFile) {
            this.targetFile = targetFile;
            this.sourceFile = sourceFile;
        }

        @Override
        public void run() {
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.sourceFile));
                this.targetFile.upload((InputStream)in, 102400L, null);
                String msg = MessageFormat.format(LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_SUCCESS"), this.targetFile.getName());
                Object[] ids = new Object[]{User.getLoggedUser().getId()};
                NotificationProxy.notifyTo(ids, msg, false, false);
            }
            catch (Exception ex) {
                CommonFileUploadAction.this.showError(LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_IO_ERROR"), ex);
                return;
            }
        }
    }
}

