/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.tasks;

import csbase.client.ClientServerManager;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectTree;
import csbase.client.project.tasks.OpenProjectRemoteTask;
import csbase.client.remote.ClientProjectObserver;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectObserver;
import csbase.logic.UserProjectInfo;
import csbase.remote.ClientRemoteLocator;
import java.awt.Dialog;
import java.awt.Window;
import java.io.Serializable;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class OpenProjectOnTreeRemoteTask
extends OpenProjectRemoteTask {
    private ProjectTree tree;

    public OpenProjectOnTreeRemoteTask(Object projectId, ProjectTree tree) {
        super(projectId, Dialog.ModalityType.DOCUMENT_MODAL);
        this.tree = tree;
    }

    @Override
    protected final void performTask() throws Exception {
        CommonClientProject project = this.tree.getProject();
        if (project != null) {
            throw new IllegalArgumentException("J\u00e1 existe projeto aberto.");
        }
        super.performTask();
        project = (CommonClientProject)this.getResult();
        ClientRemoteLocator.server.setServerSessionProperty(ClientServerManager.getInstance().getSession().getKey(), "current_project", (Serializable)new UserProjectInfo(project.getId(), project.getName(), project.getUserId()));
        try {
            project.installObserver((ProjectObserver)new ClientProjectObserver(project));
        }
        catch (Exception e) {
            DesktopFrame desktop = DesktopFrame.getInstance();
            StandardErrorDialogs.showErrorDialog((Window)desktop.getDesktopFrame(), desktop.getTitle(), (Throwable)e);
        }
        SwingThreadDispatcher.invokeLater((Runnable)new TreeUpdater(this.tree, project));
    }

    private static class TreeUpdater
    implements Runnable {
        private ProjectTree tree;
        private CommonClientProject project;

        TreeUpdater(ProjectTree tree, CommonClientProject project) {
            this.tree = tree;
            this.project = project;
        }

        @Override
        public void run() {
            this.tree.setProject(this.project);
        }
    }
}

