/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote;

import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.AlgoEvent;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.CategorySet;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import java.rmi.RemoteException;
import java.util.Observable;
import tecgraf.javautils.core.lng.LNG;

public class AlgorithmManagementObserver
extends Observable {
    private static AlgorithmManagementObserver instance = null;
    private IMessageListener listener = new IMessageListener(){

        public void onMessagesReceived(Message ... messages) throws Exception {
            for (Message message : messages) {
                AlgoEvent event = (AlgoEvent)message.getBody();
                try {
                    if (event.item instanceof AlgorithmInfo) {
                        AlgorithmInfo.update((AlgoEvent)event);
                        continue;
                    }
                    if (event.item instanceof Category) {
                        Category.update((AlgoEvent)event);
                        continue;
                    }
                    if (event.item instanceof CategorySet) {
                        CategorySet.update((AlgoEvent)event);
                        continue;
                    }
                    AlgorithmManagementObserver.this.setChanged();
                    AlgorithmManagementObserver.this.notifyObservers(event);
                }
                catch (Exception e) {
                    StandardErrorDialogs.showErrorDialog(null, LNG.get((String)"ERRO"), (Throwable)e);
                }
            }
        }
    };

    public static void start() throws RemoteException {
        if (instance != null) {
            return;
        }
        instance = new AlgorithmManagementObserver();
    }

    public static void stop() throws RemoteException {
        if (instance == null) {
            return;
        }
        instance.uninstall();
    }

    public void install() {
        MessageProxy.addListener(this.listener, AlgoEvent.class);
    }

    public void uninstall() {
        MessageProxy.removeListener(this.listener);
    }

    public static AlgorithmManagementObserver getInstance() {
        return instance;
    }

    private AlgorithmManagementObserver() throws RemoteException {
        this.install();
    }
}

