/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies;

import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.eventlogservice.LogsInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.EventLogServiceInterface;
import java.awt.Window;
import java.util.Date;
import tecgraf.javautils.core.lng.LNG;

public class EventLogProxy {
    private static void showError(String msg) {
        DesktopFrame mainFrame = DesktopFrame.getInstance();
        if (mainFrame == null) {
            return;
        }
        DesktopComponentFrame jFrame = mainFrame.getDesktopFrame();
        if (jFrame == null) {
            return;
        }
        String title = LNG.get((String)"eventlog.proxy.title");
        StandardErrorDialogs.showErrorDialog((Window)jFrame, title, msg);
    }

    public static boolean addClientInformation(String[] queue, String info) {
        return EventLogProxy.addClientInformation(queue, new String[]{info});
    }

    public static boolean addClientInformation(final String[] queue, final String[] info) {
        if (!ClientRemoteMonitor.getInstance().isAlive()) {
            return false;
        }
        final EventLogServiceInterface eventLogService = ClientRemoteLocator.eventLogService;
        DesktopFrame mainFrame = DesktopFrame.getInstance();
        if (mainFrame == null || eventLogService == null) {
            EventLogProxy.showError(LNG.get((String)"eventlog.proxy.msg.no_server"));
            return false;
        }
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                eventLogService.addClientInformation(queue, info);
            }
        };
        String msg = LNG.get((String)"eventlog.proxy.msg.sending_data");
        String title = LNG.get((String)"eventlog.proxy.title");
        return task.execute(mainFrame.getDesktopFrame(), title, msg);
    }

    public static LogsInfo find(final String[][] queues, final Date startDate, final Date endDate) {
        if (!ClientRemoteMonitor.getInstance().isAlive()) {
            return null;
        }
        final EventLogServiceInterface eventLogService = ClientRemoteLocator.eventLogService;
        DesktopFrame mainFrame = DesktopFrame.getInstance();
        if (mainFrame == null || eventLogService == null) {
            EventLogProxy.showError(LNG.get((String)"eventlog.proxy.msg.no_server"));
            return null;
        }
        RemoteTask<LogsInfo> task = new RemoteTask<LogsInfo>(){

            public void performTask() throws Exception {
                this.setResult(eventLogService.find(queues, startDate, endDate));
            }
        };
        String msg = LNG.get((String)"eventlog.proxy.msg.reading_data");
        String title = LNG.get((String)"eventlog.proxy.title");
        if (task.execute(mainFrame.getDesktopFrame(), title, msg)) {
            return (LogsInfo)task.getResult();
        }
        return null;
    }
}

