/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies;

import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.UserGroup;
import csbase.logic.UserGroupInfo;
import java.awt.Window;
import java.util.Vector;
import tecgraf.javautils.core.lng.LNG;

public class UserGroupProxy {
    public static Vector<UserGroup> getAllUserGroups(Window owner, String title, String message) {
        RemoteTask<Vector<UserGroup>> task = new RemoteTask<Vector<UserGroup>>(){

            public void performTask() throws Exception {
                this.setResult(new Vector(UserGroup.getAllUserGroups()));
            }
        };
        if (task.execute(owner, title, message)) {
            Vector userGroupsVector = (Vector)task.getResult();
            if (userGroupsVector == null || userGroupsVector.size() <= 0) {
                return new Vector<UserGroup>();
            }
            return userGroupsVector;
        }
        return new Vector<UserGroup>();
    }

    public static UserGroup getUserGroup(Window owner, String title, String message, final Object userGroupId) {
        RemoteTask<UserGroup> task = new RemoteTask<UserGroup>(){

            public void performTask() throws Exception {
                this.setResult(UserGroup.getUserGroup((Object)userGroupId));
            }
        };
        if (task.execute(owner, title, message)) {
            return (UserGroup)task.getResult();
        }
        return null;
    }

    public static UserGroup getUserGroupByName(Window owner, String title, String message, final String name) {
        RemoteTask<UserGroup> task = new RemoteTask<UserGroup>(){

            public void performTask() throws Exception {
                this.setResult(UserGroup.getUserGroupByName((String)name));
            }
        };
        if (task.execute(owner, title, message)) {
            return (UserGroup)task.getResult();
        }
        return null;
    }

    public static UserGroup createUserGroup(Window owner, String title, String message, final UserGroupInfo info) {
        RemoteTask<UserGroup> task = new RemoteTask<UserGroup>(){

            public void performTask() throws Exception {
                this.setResult(UserGroup.createUserGroup((UserGroupInfo)info));
            }
        };
        if (task.execute(owner, title, message)) {
            UserGroup userGroup = (UserGroup)task.getResult();
            if (userGroup == null) {
                StandardErrorDialogs.showErrorDialog(owner, title, LNG.get((String)"IAS_USERGROUP_ALREADY_EXISTS_ERROR"));
            }
            return userGroup;
        }
        return null;
    }

    public static UserGroup modifyUserGroup(Window owner, String title, String message, final Object userGroupId, final UserGroupInfo info) {
        RemoteTask<UserGroup> task = new RemoteTask<UserGroup>(){

            public void performTask() throws Exception {
                this.setResult(UserGroup.modifyUserGroup((Object)userGroupId, (UserGroupInfo)info));
            }
        };
        if (task.execute(owner, title, message)) {
            UserGroup userGroup = (UserGroup)task.getResult();
            if (userGroup == null) {
                StandardErrorDialogs.showErrorDialog(owner, title, LNG.get((String)"IAS_USERGROUP_ALREADY_EXISTS_ERROR"));
            }
            return userGroup;
        }
        return null;
    }

    public static void deleteUserGroup(Window owner, String title, String message, final Object userGroupId) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                UserGroup.deleteUserGroup((Object)userGroupId);
            }
        };
        task.execute(owner, title, message);
    }
}

