/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies.messageservice.consumers;

import csbase.client.remote.srvproxies.messageservice.consumers.IMessageConsumer;
import csbase.remote.MessageServiceInterface;
import csbase.util.messages.Message;
import java.rmi.RemoteException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import tecgraf.javautils.core.filter.IFilter;

public class MessagePollingConsumer
implements IMessageConsumer {
    private MessageServiceInterface service;
    private long period;
    private TimerTask task;
    private IMessageConsumer.IListener listener;
    private IFilter<Message> filter;

    public MessagePollingConsumer(MessageServiceInterface service, long period, TimeUnit unit) {
        if (service == null) {
            throw new IllegalArgumentException("service == null");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("period <= 0");
        }
        if (unit == null) {
            throw new IllegalArgumentException("unit == null");
        }
        this.service = service;
        this.period = unit.toMillis(period);
    }

    @Override
    public synchronized void setListener(IMessageConsumer.IListener listener, IFilter<Message> filter) {
        if (listener == null) {
            throw new IllegalArgumentException("listener == null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("filter == null");
        }
        this.listener = listener;
        this.filter = filter;
        this.startPolling();
    }

    @Override
    public synchronized void clearListener() {
        this.stopPolling();
        this.listener = null;
        this.filter = null;
    }

    public void startPolling() {
        if (this.task == null) {
            Timer timer = new Timer();
            this.task = new TimerTask(){

                @Override
                public void run() {
                    try {
                        Message[] messages = MessagePollingConsumer.this.service.receive(MessagePollingConsumer.this.filter);
                        MessagePollingConsumer.this.listener.onMessagesReceived(messages);
                    }
                    catch (RemoteException e) {
                        MessagePollingConsumer.this.listener.onExceptionThrown(e);
                    }
                }
            };
            timer.scheduleAtFixedRate(this.task, 0L, this.period);
        }
    }

    private void stopPolling() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }
}

