/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser.filetablepanel;

import csbase.client.project.ClientProjectFileType;
import csbase.client.util.filechooser.images.ChooserImages;
import csbase.client.util.filechooser.util.ClientFileChooserUtils;
import csbase.logic.ClientFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import tecgraf.javautils.core.lng.FormatUtils;

class ClientFileTableRenderer
extends DefaultTableCellRenderer {
    private static final Font DEFAULT_FONT = new JLabel().getFont().deriveFont(0);

    ClientFileTableRenderer() {
    }

    private void adjustAsModifiedDate(JLabel label, ClientFile file) {
        this.setLabelAttrBasedOnHiddenOrLocked(label, file);
        if (!file.canRead()) {
            label.setText("-");
            return;
        }
        long date = file.getModificationDate();
        if (date == 0L) {
            label.setText("-");
            return;
        }
        String text = this.dateToString(date);
        label.setText(text);
        label.setHorizontalAlignment(4);
    }

    private void adjustAsName(JLabel label, ClientFile file) {
        this.setLabelAttrBasedOnHiddenOrLocked(label, file);
        label.setHorizontalAlignment(2);
        String fileName = file.getName();
        label.setText(fileName);
        boolean isDir = file.isDirectory();
        if (!isDir && !file.canRead()) {
            label.setHorizontalTextPosition(2);
            label.setVerticalTextPosition(3);
            label.setIcon(ChooserImages.LOCKED_FILE_ICON);
            return;
        }
        label.setHorizontalTextPosition(2);
        label.setVerticalTextPosition(0);
        label.setToolTipText(null);
    }

    private void setLabelAttrBasedOnHiddenOrLocked(JLabel label, ClientFile file) {
        boolean isHidden = ClientFileChooserUtils.isHiddenFile(file);
        boolean isLocked = !file.canRead();
        Color color = Color.black;
        Font font = DEFAULT_FONT;
        if (isHidden) {
            color = Color.gray;
            font = DEFAULT_FONT.deriveFont(2);
        }
        if (isLocked) {
            color = Color.gray;
        }
        label.setForeground(color);
        label.setFont(font);
    }

    private void adjustAsSize(JLabel label, ClientFile file) {
        this.setLabelAttrBasedOnHiddenOrLocked(label, file);
        if (file.isDirectory() || file.size() < 0L) {
            label.setText("-");
            label.setHorizontalAlignment(0);
        } else {
            long size = file.size();
            label.setText(FormatUtils.formatSize((long)size, (int)2));
            label.setHorizontalAlignment(4);
        }
    }

    private void adjustAsType(JLabel label, ClientFile cpf) {
        if (cpf.isDirectory()) {
            ImageIcon icon = ClientFileChooserUtils.getDirectoryImageIcon(cpf);
            label.setIcon(icon);
            label.setToolTipText(null);
        } else {
            String type = cpf.getType();
            ClientProjectFileType fileType = ClientProjectFileType.getFileType(type);
            String desc = fileType.getDescription();
            ImageIcon icon = fileType.getBaseIcon();
            if (!cpf.canRead()) {
                icon = fileType.getCutIcon();
            }
            label.setToolTipText(desc);
            label.setIcon(icon);
        }
        label.setHorizontalAlignment(0);
        label.setText(null);
    }

    private String dateToString(long time) {
        Date date = new Date(time);
        String fmt = "%1$td/%1$tm/%1$ty - %1$tH:%1$tM:%1$tS";
        String text = String.format("%1$td/%1$tm/%1$ty - %1$tH:%1$tM:%1$tS", date);
        return text;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ClientFile clientFile = (ClientFile)value;
        if (clientFile == null) {
            return component;
        }
        JLabel label = (JLabel)component;
        label.setForeground(Color.black);
        label.setFont(DEFAULT_FONT);
        label.setText(null);
        label.setToolTipText(null);
        label.setHorizontalAlignment(0);
        label.setIcon(null);
        if (column == 0) {
            this.adjustAsType(label, clientFile);
        } else if (column == 1) {
            this.adjustAsName(label, clientFile);
        } else if (column == 2) {
            this.adjustAsSize(label, clientFile);
        } else if (column == 3) {
            this.adjustAsModifiedDate(label, clientFile);
        }
        return label;
    }
}

