/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JTextArea;

public class LinedTextArea
extends JTextArea {
    private Color frameBgColor = new Color(220, 220, 220);
    private Color frameFgColor = new Color(0, 0, 180);
    private Color prefixFgColor = new Color(150, 0, 0);
    private String prefix = "x: ";
    private int numCharsFrameWidth = 5;

    @Override
    public Insets getInsets() {
        return this.getInsets(new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getInsets(Insets insets) {
        Insets i = super.getInsets(insets);
        i.left += this.getLinePanelWidth();
        return i;
    }

    private int getLinePanelWidth() {
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        String ch = "n";
        String rep = "";
        int n = this.numCharsFrameWidth + this.prefix.length();
        for (int i = 0; i < n; ++i) {
            rep = rep + "n";
        }
        return fontMetrics.stringWidth(rep);
    }

    public final void setNumCharsFrameWidth(int numChars) {
        this.numCharsFrameWidth = numChars;
    }

    public final int getNumCharsFrameWidth() {
        return this.numCharsFrameWidth;
    }

    @Override
    public void paintComponent(Graphics g) {
        Insets insets = this.getInsets();
        Rectangle clip = g.getClipBounds();
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        if (clip.x >= insets.left) {
            super.paintComponent(g);
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int lineNumber = (clip.y + insets.top) / fontHeight + 1;
        int y = fm.getAscent() + insets.top;
        if (y < clip.y) {
            y = lineNumber * fontHeight - (fontHeight - fm.getAscent());
        }
        int ystart = y;
        int yend = y + clip.height + fontHeight;
        g.setColor(this.frameBgColor);
        g.fillRect(0, ystart - fontHeight, insets.left, yend - ystart);
        int prefixWidth = fm.stringWidth(this.prefix);
        int lnxstart = insets.left - this.getLinePanelWidth();
        g.setColor(this.frameFgColor);
        while (y < yend) {
            g.setColor(this.prefixFgColor);
            g.drawString(this.prefix, lnxstart, y);
            g.setColor(this.frameFgColor);
            g.drawString(lineNumber + " ", lnxstart + prefixWidth, y);
            y += fontHeight;
            ++lineNumber;
        }
        super.paintComponent(g);
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final void setPrefix(String prefix) {
        this.prefix = prefix == null ? "" : prefix;
    }

    public LinedTextArea() {
        this.setOpaque(false);
    }
}

