/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.sga;

import csbase.client.algorithms.tasks.CreateFlowConfiguratorTask;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.sga.MultipleCommandSubmission;
import csbase.exception.ParseException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.CommandSubmission;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.Window;
import tecgraf.javautils.core.lng.LNG;

public class CreateMultipleFlowSubmissionTask
extends RemoteTask<MultipleCommandSubmission> {
    private Window owner;
    private String[][] paramTable;
    private FlowAlgorithmConfigurator configurator;

    public CreateMultipleFlowSubmissionTask(Window owner, String[][] paramTable, FlowAlgorithmConfigurator configurator) {
        this.owner = owner;
        this.paramTable = paramTable;
        this.configurator = configurator;
    }

    protected void performTask() throws Exception {
        FlowAlgorithmConfigurator flowConfigurator = this.configurator;
        MultipleCommandSubmission flowSubmission = new MultipleCommandSubmission();
        Flow flow = flowConfigurator.getFlow();
        String flowName = flow.getName();
        CommonClientProject project = DesktopFrame.getInstance().getProject();
        if (this.paramTable.length > 0) {
            for (int i = 1; i < this.paramTable.length; ++i) {
                Object userId;
                flow.setName(flowName + " #" + i);
                FlowAlgorithmConfigurator newConfigurator = CreateFlowConfiguratorTask.runTask(this.owner, flow);
                for (int j = 0; j < this.paramTable[i].length; ++j) {
                    LocalizedMessage message;
                    String paramName = this.paramTable[0][j];
                    String parameterValue = this.paramTable[i][j];
                    try {
                        newConfigurator.setParameterValue(paramName, parameterValue);
                        continue;
                    }
                    catch (ParameterNotFoundException e) {
                        message = new LocalizedMessage(CreateMultipleFlowSubmissionTask.class, "parameter.not.found.error", new Object[]{paramName});
                        ValidationError validationError = new ValidationError(message);
                        flowSubmission.clearSubmissions();
                        flowSubmission.setValidation((Validation)validationError);
                        this.setResult(flowSubmission);
                        return;
                    }
                    catch (ParseException e) {
                        message = new LocalizedMessage(CreateMultipleFlowSubmissionTask.class, "parameter.parse.error", new Object[]{parameterValue, paramName});
                        ValidationError validationError = new ValidationError(message);
                        flowSubmission.clearSubmissions();
                        flowSubmission.setValidation((Validation)validationError);
                        this.setResult(flowSubmission);
                        return;
                    }
                }
                Object projectId = project.getId();
                ValidationContext context = new ValidationContext(ValidationMode.FULL, projectId, userId = User.getLoggedUser().getId());
                Validation result = newConfigurator.validate(context);
                if (!result.isWellSucceded()) {
                    flowSubmission.clearSubmissions();
                    flowSubmission.setValidation(result);
                    this.setResult(flowSubmission);
                    return;
                }
                CommandSubmission submission = new CommandSubmission((AlgorithmConfigurator)newConfigurator, project.getId());
                flowSubmission.addSubmission(submission);
            }
        }
        this.setResult(flowSubmission);
    }

    public static final MultipleCommandSubmission runTask(Window window, String[][] paramTable, FlowAlgorithmConfigurator configurator) {
        LocalizedMessage errorMessage;
        String msg;
        CreateMultipleFlowSubmissionTask task = new CreateMultipleFlowSubmissionTask(window, paramTable, configurator);
        String className = CreateMultipleFlowSubmissionTask.class.getSimpleName();
        String title = LNG.get((String)(className + ".title"));
        if (task.execute(window, title, msg = LNG.get((String)(className + ".msg")))) {
            return (MultipleCommandSubmission)task.getResult();
        }
        if (task.wasCancelled()) {
            errorMessage = new LocalizedMessage(CreateMultipleFlowSubmissionTask.class, "cancelled");
        } else {
            Exception error = task.getError();
            error.printStackTrace();
            errorMessage = new LocalizedMessage(CreateMultipleFlowSubmissionTask.class, "error");
        }
        ValidationError validationError = new ValidationError(errorMessage);
        MultipleCommandSubmission submission = new MultipleCommandSubmission();
        submission.setValidation((Validation)validationError);
        return submission;
    }
}

