/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.logic.algorithms.parsers.ParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;

public abstract class SimpleParameterParser<T extends SimpleParameter<?>>
extends ParameterParser
implements ParameterFactory {
    static final String PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE = "padrao";
    static final String PARAMETER_ELEMENT_HIDDEN_ATTRIBUTE = "oculto";
    static final boolean PARAMETER_ELEMENT_HIDDEN_ATTRIBUTE_DEFAULT_VALUE = false;
    static final String PARAMETER_ELEMENT_DESCRIPTION_ATTRIBUTE = "dica";
    static final String PARAMETER_ELEMENT_LABEL_ATTRIBUTE = "rotulo";
    static final String PARAMETER_ELEMENT_NAME_ATTRIBUTE = "nome";
    static final String PARAMETER_ELEMENT_OPTIONAL_ATTRIBUTE = "opcional";
    static final boolean PARAMETER_ELEMENT_OPTIONAL_DEFAULT_VALUE = false;
    static final String PARAMETER_ELEMENT_IGNORE_IF_DISABLED_ATTRIBUTE = "ignorar_se_desabilitado";
    static final boolean PARAMETER_ELEMENT_IGNORE_IF_DISABLED_DEFAULT_VALUE = false;
    static final String PARAMETER_ELEMENT_IGNORE_IF_INVISIBLE_ATTRIBUTE = "ignorar_se_oculto";
    static final boolean PARAMETER_ELEMENT_IGNORE_IF_INVISIBLE_DEFAULT_VALUE = false;

    public abstract T createSimpleParameter(XmlParser var1, String var2, String var3, String var4, boolean var5, boolean var6, String var7, ParameterGroup var8) throws ParseException;

    public T createParameter(XmlParser parser, String defaultCommandLinePattern, ParameterGroup group) throws ParseException {
        String name = parser.extractAttributeValue(PARAMETER_ELEMENT_NAME_ATTRIBUTE);
        String label = parser.extractAttributeValue(PARAMETER_ELEMENT_LABEL_ATTRIBUTE);
        String description = parser.extractAttributeValue(PARAMETER_ELEMENT_DESCRIPTION_ATTRIBUTE);
        boolean ignoreIfInvisible = parser.extractAttributeValueAsBoolean(PARAMETER_ELEMENT_IGNORE_IF_INVISIBLE_ATTRIBUTE, false);
        boolean ignoreIfDisabled = parser.extractAttributeValueAsBoolean(PARAMETER_ELEMENT_IGNORE_IF_DISABLED_ATTRIBUTE, false);
        boolean isOptional = parser.extractAttributeValueAsBoolean(PARAMETER_ELEMENT_OPTIONAL_ATTRIBUTE, false);
        boolean isHidden = parser.extractAttributeValueAsBoolean(PARAMETER_ELEMENT_HIDDEN_ATTRIBUTE, false);
        String parameterCommandLinePattern = this.loadCommandLinePattern(parser, defaultCommandLinePattern);
        T parameter = this.createSimpleParameter(parser, name, label, description, isOptional, !isHidden, parameterCommandLinePattern, group);
        parser.checkAttributes();
        ((SimpleParameter)parameter).setIgnoreIfDisabled(ignoreIfDisabled);
        ((SimpleParameter)parameter).setIgnoreIfInvisible(ignoreIfInvisible);
        return parameter;
    }
}

