/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.HiddenParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.elements.IElementStructure;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedElement;
import csbase.logic.algorithms.parsers.elements.ParsedParameter;
import csbase.logic.algorithms.parsers.elements.attributes.IElementAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.StringAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;

public class HiddenParameterParser
implements ParameterFactory {
    static final String HIDDEN_PARAMETER_ELEMENT = "oculto";
    private static final String HIDDEN_PARAMETER_ELEMENT_VALUE_ATTRIBUTE = "valor";

    public HiddenParameter createParameter(XmlParser parser, String defaultCommandLinePattern, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        ParameterStructure<HiddenParameter> structure = this.getHiddenStructure();
        HashMap values = new HashMap();
        for (IElementAttribute<?> attribute : structure.getAttributes()) {
            values.put(attribute, parser.extractAttribute(attribute));
        }
        parser.checkAttributes();
        HashMap attributeValues = values;
        Map<IElementStructure<?>, List<ParsedElement>> children = parser.extractChildren(structure.getChildElements());
        ParsedParameter definition = new ParsedParameter(attributeValues, children, defaultCommandLinePattern);
        String name = definition.getName();
        String attributeValue = (String)definition.getAttributeValue(HIDDEN_PARAMETER_ELEMENT_VALUE_ATTRIBUTE);
        String commandLinePattern = definition.getCommandLinePattern();
        if (commandLinePattern == null) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.NoCommandPattern"), name, attributeValue);
        }
        return new HiddenParameter(name, attributeValue, commandLinePattern);
    }

    @Override
    public List<ParameterStructure<?>> getParameterStructures() {
        ParameterStructure<HiddenParameter> structure = this.getHiddenStructure();
        return Collections.singletonList(structure);
    }

    private ParameterStructure<HiddenParameter> getHiddenStructure() {
        ParameterStructure<HiddenParameter> structure = new ParameterStructure<HiddenParameter>(HIDDEN_PARAMETER_ELEMENT, HiddenParameter.class);
        structure.addAttribute(new StringAttribute(HIDDEN_PARAMETER_ELEMENT_VALUE_ATTRIBUTE));
        return structure;
    }
}

