/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.xml.algorithmspack;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.xml.algorithmspack.XMLCategorySetElement;
import csbase.logic.algorithms.xml.algorithmspack.XMLPropertySetElement;
import csbase.logic.algorithms.xml.algorithmspack.XMLVersionSetElement;
import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import tecgraf.javautils.xml.ImprovedXMLListIterator;
import tecgraf.javautils.xml.XMLBasicElement;
import tecgraf.javautils.xml.XMLElementInterface;

public class XmlAlgorithmElement
extends XMLBasicElement {
    private AlgorithmInfo currentAlgo;

    public XmlAlgorithmElement() {
        this.setTag("algoritmo");
    }

    public XmlAlgorithmElement(AlgorithmInfo algoInfo) {
        this();
        this.currentAlgo = algoInfo;
    }

    public void endTag(List<XMLElementInterface> childrenList) {
        String id = null;
        String name = null;
        String desc = null;
        Hashtable<String, String> propertiesValues = null;
        Hashtable<AlgorithmVersionId, AlgorithmVersionInfo> versions = null;
        List<String> categoryFullNames = null;
        ImprovedXMLListIterator iterator = new ImprovedXMLListIterator(childrenList);
        XMLElementInterface nextElem = iterator.next("*");
        while (nextElem != null) {
            if (this.isIdElement(nextElem)) {
                id = nextElem.getStrValue();
            }
            if (this.isNameElement(nextElem)) {
                name = nextElem.getStrValue();
            }
            if (this.isDescElement(nextElem)) {
                desc = nextElem.getStrValue();
            }
            if (this.isAlgoPropertiesElement(nextElem)) {
                propertiesValues = ((XMLPropertySetElement)nextElem).getPropertyValues();
            }
            if (this.isAlgoVersionsElement(nextElem)) {
                versions = ((XMLVersionSetElement)nextElem).getVersionsValues();
            }
            if (this.isAlgoCategoriesElement(nextElem)) {
                categoryFullNames = ((XMLCategorySetElement)nextElem).getCategoryFullNameSet();
            }
            nextElem = iterator.next("*");
        }
        this.currentAlgo = this.createAlgorithmInfo(id, name, null, null, propertiesValues, versions);
        this.currentAlgo.setDescription(desc);
        this.currentAlgo.setAlgoPackCategoryFullNames(categoryFullNames);
    }

    protected void printAlgoData(AlgorithmInfo algo) {
        System.out.println("\nDados do Algoritmo criado a partir do xml: ");
        System.out.println("Id: " + algo.getId());
        System.out.println("Nome: " + algo.getName());
        System.out.println("Descri\u00e7\u00e3o: " + algo.getDescription());
        Hashtable<String, String> propertyValues = algo.getPropertyValues();
        Set<Map.Entry<String, String>> entrySet = propertyValues.entrySet();
        System.out.println("\n>> Propriedades do algoritmo: " + entrySet.size());
        for (Map.Entry<String, String> entry : entrySet) {
            System.out.println(entry.getKey() + " = " + entry.getValue());
        }
        Vector<AlgorithmVersionInfo> versions = algo.getVersions();
        System.out.println("\n>> Vers\u00f5es do algoritmo: " + versions.size());
        for (AlgorithmVersionInfo algoVersionInfo : versions) {
            System.out.println("\n-> Vers\u00e3o: " + algoVersionInfo);
            System.out.println("descri\u00e7\u00e3o: " + algoVersionInfo.getDescription());
            Map<String, String> properties = algoVersionInfo.getPropertyValues();
            entrySet.clear();
            entrySet = properties.entrySet();
            System.out.println("\nPropriedades da vers\u00e3o do algoritmo: " + entrySet.size());
            for (Map.Entry<String, String> entry : entrySet) {
                System.out.println(entry.getKey() + " = " + entry.getValue());
            }
        }
        List<String> list = algo.getAlgoPackCategoryFullNames();
        System.out.println("\n>> Categorias do algoritmo: " + list.size());
        for (String categoryFullName : list) {
            System.out.println("\n-> Nome completo: " + categoryFullName);
        }
    }

    private AlgorithmInfo createAlgorithmInfo(String id, String name, String dir, String algorithmRepositoryPath, Hashtable<String, String> propertyValues, Hashtable<AlgorithmVersionId, AlgorithmVersionInfo> versions) {
        return new AlgorithmInfo(id, name, dir, algorithmRepositoryPath, propertyValues, versions);
    }

    public void write(Writer arg0, String arg1) throws IOException {
    }

    public AlgorithmInfo getAlgorithmInfo() {
        return this.currentAlgo;
    }

    private boolean isIdElement(XMLElementInterface xmlElem) {
        return xmlElem.getTag().equals("id");
    }

    private boolean isNameElement(XMLElementInterface xmlElem) {
        return xmlElem.getTag().equals("nome");
    }

    private boolean isDescElement(XMLElementInterface xmlElem) {
        return xmlElem.getTag().equals("descricao");
    }

    private boolean isAlgoPropertiesElement(XMLElementInterface xmlElem) {
        return xmlElem.getTag().equals("propriedades");
    }

    private boolean isAlgoVersionsElement(XMLElementInterface xmlElem) {
        return xmlElem.getTag().equals("versoes");
    }

    private boolean isAlgoCategoriesElement(XMLElementInterface xmlElem) {
        return xmlElem.getTag().equals("categorias");
    }
}

