/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.AdministrationEvent;
import csbase.logic.Getter;
import csbase.logic.PlatformInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class Platform
implements Serializable {
    private static Hashtable<Object, Platform> platforms = new Hashtable();
    private static boolean hasAllPlatforms = false;
    private static Observable observable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };
    private static Comparator<Platform> nameComparator = null;
    private static Comparator descrComparator = null;
    private final Object id;
    private final PlatformInfo info;

    public boolean equals(Object obj) {
        if (!(obj instanceof Platform)) {
            return false;
        }
        Platform platform = (Platform)obj;
        return platform.getId().equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equalContents(Object obj) {
        if (!(obj instanceof Platform)) {
            return false;
        }
        Platform platform = (Platform)obj;
        return platform.getId().equals(this.id) && platform.getPlatformInfo().equals(this.info);
    }

    public static Platform getPlatform(Object id) throws RemoteException {
        if (id == null) {
            return null;
        }
        Platform platform = platforms.get(id);
        if (platform == null && !hasAllPlatforms && (platform = ClientRemoteLocator.administrationService.getPlatform(id)) != null) {
            platforms.put(id, platform);
        }
        return platform;
    }

    public static Platform getPlatformByName(String name) throws Exception {
        List<Platform> allPlatforms = Platform.getAllPlatforms();
        for (Platform platform : allPlatforms) {
            if (!platform.getName().equalsIgnoreCase(name)) continue;
            return platform;
        }
        return null;
    }

    public static List<Platform> getAllPlatforms() throws Exception {
        if (hasAllPlatforms) {
            return Platform.toVector();
        }
        List<Platform> allPlatforms = ClientRemoteLocator.administrationService.getAllPlatforms();
        for (Platform platform : allPlatforms) {
            if (platforms.containsKey(platform.id)) continue;
            platforms.put(platform.id, platform);
        }
        hasAllPlatforms = true;
        return allPlatforms;
    }

    public static List<Platform> getAllPlatforms(boolean sortByName) throws Exception {
        List<Platform> allPlatforms = Platform.getAllPlatforms();
        if (sortByName) {
            Collections.sort(allPlatforms, Platform.getNameComparator());
        }
        return allPlatforms;
    }

    public static Platform createPlatform(PlatformInfo info) throws Exception {
        if (info.name == null || info.name.trim().equals("")) {
            throw new Exception("nome n\u00e3o pode ser vazio");
        }
        if (Platform.getPlatformByName(info.name) != null) {
            return null;
        }
        Platform platform = ClientRemoteLocator.administrationService.createPlatform(info);
        platforms.put(platform.id, platform);
        return platform;
    }

    public static Platform modifyPlatform(Object id, PlatformInfo info) throws Exception {
        Platform platform = Platform.getPlatform(id);
        if (platform == null) {
            return null;
        }
        if (!platform.getName().equals(info.name)) {
            return null;
        }
        platform = ClientRemoteLocator.administrationService.modifyPlatform(id, info);
        platforms.put(platform.id, platform);
        return platform;
    }

    public static void deletePlatform(Object id) throws Exception {
        ClientRemoteLocator.administrationService.deletePlatform(id);
        platforms.remove(id);
    }

    public Object getId() {
        return this.id;
    }

    public String getName() {
        return this.info.name;
    }

    public String getDescription() {
        return this.info.description;
    }

    public PlatformInfo getPlatformInfo() {
        return (PlatformInfo)this.info.clone();
    }

    private static Vector<Platform> toVector() {
        Vector<Platform> allPlatforms = new Vector<Platform>();
        Enumeration<Platform> elems = platforms.elements();
        while (elems.hasMoreElements()) {
            allPlatforms.add(elems.nextElement());
        }
        return allPlatforms;
    }

    public static Comparator<Platform> getNameComparator() {
        if (nameComparator == null) {
            nameComparator = new Comparator<Platform>(){

                @Override
                public int compare(Platform p1, Platform p2) {
                    return p1.getName().compareTo(p2.getName());
                }
            };
        }
        return nameComparator;
    }

    public static Comparator getDescrComparator() {
        if (descrComparator == null) {
            descrComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Platform)o1).getDescription().compareTo(((Platform)o2).getDescription());
                }
            };
        }
        return descrComparator;
    }

    public static Getter getNameGetter() {
        Getter nameGetter = new Getter(){

            @Override
            public Object get(Object o) {
                return ((Platform)o).getName();
            }
        };
        return nameGetter;
    }

    public static Getter getIdGetter() {
        Getter idGetter = new Getter(){

            @Override
            public Object get(Object o) {
                return ((Platform)o).getId();
            }
        };
        return idGetter;
    }

    public static Getter getDescriptionGetter() {
        Getter descriptionGetter = new Getter(){

            @Override
            public Object get(Object o) {
                return ((Platform)o).getDescription();
            }
        };
        return descriptionGetter;
    }

    public static void addObserver(Observer obs) {
        observable.addObserver(obs);
    }

    public static void deleteObserver(Observer obs) {
        observable.deleteObserver(obs);
    }

    public static void update(AdministrationEvent event) {
        Platform platform = (Platform)event.item;
        Object id = platform.id;
        switch (event.type) {
            case 1: 
            case 2: {
                platforms.put(id, platform);
                break;
            }
            case 3: {
                platforms.remove(id);
            }
        }
        observable.notifyObservers(event);
    }

    public Platform(Object id, PlatformInfo info) {
        this.id = id;
        this.info = info;
    }

    static {
        RestartManager.getInstance().addListener(new RestartListener(){

            public void restart() {
                platforms = new Hashtable();
                hasAllPlatforms = false;
                observable.deleteObservers();
            }
        });
    }
}

