/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.ProgressData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ProgressDataParser {
    private static final String PROGRESS_KEY = "progresso";
    private static final String PROGRESS_NODE_KEY_PATTERN = "^progresso\\.[0-9]+$";

    public boolean hasProgressData(Map<String, String> dynamicData) {
        if (dynamicData.containsKey(PROGRESS_KEY)) {
            return true;
        }
        for (String key : dynamicData.keySet()) {
            if (!key.matches(PROGRESS_NODE_KEY_PATTERN)) continue;
            return true;
        }
        return false;
    }

    public ProgressData extractOverallProgressData(Map<String, String> dynamicData, int expectedPartialProgress) {
        if (dynamicData == null) {
            return null;
        }
        String progressData = dynamicData.get(PROGRESS_KEY);
        if (progressData != null) {
            if (expectedPartialProgress == 1) {
                return this.parseProgressData(progressData);
            }
            return null;
        }
        Map<Integer, ProgressData> map = this.extractProgressDataMap(dynamicData);
        if (expectedPartialProgress == map.size()) {
            return this.calculateOverallProgress(map.values());
        }
        return null;
    }

    public Map<Integer, ProgressData> extractProgressDataMap(Map<String, String> dynamicData) {
        HashMap<Integer, ProgressData> values = new HashMap<Integer, ProgressData>();
        if (dynamicData == null) {
            return values;
        }
        Set<Map.Entry<String, String>> entrySet = dynamicData.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            ProgressData data;
            String[] keyParts;
            String key = entry.getKey();
            if (!key.matches(PROGRESS_NODE_KEY_PATTERN) || (keyParts = key.split("\\.")).length != 2 || (data = this.parseProgressData(entry.getValue())) == null) continue;
            values.put(Integer.valueOf(keyParts[1]), data);
        }
        return values;
    }

    private ProgressData calculateOverallProgress(Collection<ProgressData> data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        double total = 0.0;
        for (ProgressData progress : data) {
            Double value = progress.getValue();
            if (value == null || value.isNaN()) {
                return null;
            }
            total += value.doubleValue();
        }
        double percent = total / (double)data.size();
        return new ProgressData(percent);
    }

    private ProgressData parseProgressData(String data) {
        if (data == null) {
            return null;
        }
        String progressData = data.trim();
        int textMarkerIndex = progressData.indexOf(35);
        if (textMarkerIndex == 0) {
            return new ProgressData(progressData.substring(1).trim());
        }
        if (textMarkerIndex > 0) {
            String valueText = progressData.substring(0, textMarkerIndex).trim();
            String markedStepText = progressData.substring(textMarkerIndex + 1).trim();
            Double value = this.parseProgressValue(valueText);
            if (value.isNaN()) {
                return new ProgressData(progressData);
            }
            return new ProgressData(markedStepText, value);
        }
        Double value = this.parseProgressValue(progressData);
        if (value.isNaN()) {
            return new ProgressData(progressData);
        }
        return new ProgressData(progressData, value);
    }

    private Double parseProgressValue(String progressData) {
        try {
            if (progressData.endsWith("%")) {
                String valueStr = progressData.substring(0, progressData.length() - 1);
                return Double.parseDouble(valueStr);
            }
            if (progressData.indexOf("/") > 0) {
                String[] stringValues = progressData.split("/");
                double v1 = Integer.parseInt(stringValues[0]);
                double v2 = Integer.parseInt(stringValues[1]);
                return v1 / v2 * 100.0;
            }
            double progress = Double.parseDouble(progressData);
            if (progress >= 0.0 && progress <= 1.0) {
                return progress * 100.0;
            }
            return Double.NaN;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }
}

