/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.OutputFileListParameter;
import csbase.logic.algorithms.parsers.AbstractFileParameterParser;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.FileElementPipeAcceptanceAttribute;
import java.util.ArrayList;
import tecgraf.javautils.core.lng.LNG;

class OutputFileListParameterParser
extends AbstractFileParameterParser<OutputFileListParameter> {
    protected static final String OUTPUT_FILE_PARAMETER_ELEMENT_MUST_FORCE_EXTENSION_ATTRIBUTE = "forcar_extensao";
    protected static final boolean OUTPUT_FILE_PARAMETER_ELEMENT_MUST_FORCE_EXTENSION_DEFAULT_VALUE = false;

    OutputFileListParameterParser() {
    }

    @Override
    public OutputFileListParameter createFileParameter(ParsedSimpleParameter definition, String[] types, FileParameterMode mode) throws ParseException {
        FileParameterPipeAcceptance usesPipe = (FileParameterPipeAcceptance)((Object)definition.getAttributeValue("permitir_pipe"));
        if (usesPipe == FileParameterPipeAcceptance.TRUE || usesPipe == FileParameterPipeAcceptance.ALWAYS) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.NoPipesInputFile"));
        }
        if (types != null && types.length > 1) {
            throw new ParseException("Arquivo de sa\u00edda (sele\u00e7\u00e3o m\u00faltipla) n\u00e3o admite m\u00faltiplos tipos de arquivo");
        }
        boolean useRootDirectoryAsDefault = (Boolean)definition.getAttributeValue("usar_diretorio_raiz_como_padrao");
        ArrayList<FileURLValue> defaultValue = null;
        if (useRootDirectoryAsDefault) {
            if (mode == FileParameterMode.REGULAR_FILE) {
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.OutputFileInvalidAttribute"), "usar_diretorio_raiz_como_padrao");
            }
            defaultValue = new ArrayList<FileURLValue>();
            defaultValue.add(new FileURLValue(".", "DIRECTORY_TYPE"));
        }
        boolean mustForceExtension = (Boolean)definition.getAttributeValue(OUTPUT_FILE_PARAMETER_ELEMENT_MUST_FORCE_EXTENSION_ATTRIBUTE);
        boolean mustSort = (Boolean)definition.getAttributeValue("ordenar");
        boolean useFilter = (Boolean)definition.getAttributeValue("usar_filtro");
        OutputFileListParameter parameter = new OutputFileListParameter(definition.getName(), definition.getLabel(), definition.getDescription(), defaultValue, definition.isOptional(), definition.isVisible(), definition.getCommandLinePattern(), types, mode, mustSort, useFilter, mustForceExtension);
        return parameter;
    }

    @Override
    public ParameterStructure<OutputFileListParameter> getParameterStructure() {
        ParameterStructure<OutputFileListParameter> fileStructure = this.getFileStructure("arquivo_de_saida", OutputFileListParameter.class);
        fileStructure.addAttribute(new FileElementPipeAcceptanceAttribute("permitir_pipe", FileParameterPipeAcceptance.FALSE));
        fileStructure.addAttribute(new BooleanAttribute("usar_diretorio_raiz_como_padrao", false));
        fileStructure.addAttribute(new BooleanAttribute(OUTPUT_FILE_PARAMETER_ELEMENT_MUST_FORCE_EXTENSION_ATTRIBUTE, false));
        fileStructure.addAttribute(new BooleanAttribute("usar_filtro", false));
        fileStructure.addAttribute(new BooleanAttribute("ordenar", true));
        return fileStructure;
    }

    @Override
    protected boolean acceptBothCategory() {
        return false;
    }
}

