/*
 * $Id:$
 */

package csbase.exception.algorithms;

import csbase.exception.CSBaseException;
import csbase.logic.algorithms.AlgorithmVersionId;
import tecgraf.javautils.core.lng.LNG;


/**
 * Exceo de algortimo no encontrado.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class AlgorithmVersionNotFoundException extends CSBaseException {

  /**
   * Construtor
   * 
   * @param algorithmName nome
   * @param versionId verso (id)
   */
  public AlgorithmVersionNotFoundException(String algorithmName,
    AlgorithmVersionId versionId) {
    super(LNG.get("AlgorithmVersionNotFoundException.error_version_not_found"),
      versionId, algorithmName);
  }

}
