/*
 * $Id$
 */
package csbase.logic.algorithms;

import java.io.Serializable;
import java.text.MessageFormat;

import tecgraf.javautils.core.lng.LNG;

/**
 * A classe <code>AlgorithmProperty</code> define as propriedades com seus tipos
 * dos algoritmos e suas verses.
 */
public class AlgorithmProperty implements Serializable{
  /**
   * Tipo da Propriedade.
   */
  public enum PropertyType {
    /**
     * Tipo Texto.
     */
    STRING,
    /**
     * Tipo Real.
     */
    DOUBLE
  }
  
  /** Sufixo que acompanha a chave da propriedade para definio do tipo */
  public final static String TYPE_SUFFIX = ".tipo"; 
  
  /** Chave da propriedade */
  private String key;
  
  /** Rtulo da Propriedade */
  private String label;
  
  /** Tipo da Propriedade */
  private PropertyType type;
  
  /**
   * Construtor.
   * 
   * @param key Chave da propriedade
   * @param label Rtulo da Propriedade
   * @param type Tipo da Propriedade
   */
  public AlgorithmProperty (String key, String label, PropertyType type) {
    this.key = key;
    this.label = label;
    this.type = type;
  }
  
  /**
   * Construtor. O tipo da propriedade  definido como <code>String</code>.
   * 
   * @param key Chave da propriedade
   * @param label Rtulo da Propriedade
   */
  public AlgorithmProperty (String key, String label) {
    this(key, label, PropertyType.STRING);
  }

  /**
   * Retorna a chave da propriedade.
   * 
   * @return a chave da propriedade.
   */
  public String getKey() {
    return key;
  }

  /**
   * Retorna o rtulo da propriedade.
   * 
   * @return o rtulo da propriedade.
   */
  public String getLabel() {
    return label;
  }

  /**
   * Retorna o tipo da propriedade.
   * 
   * @return o tipo da propriedade.
   */
  public PropertyType getType() {
    return type;
  }

  /**
   * Indica se o <code>value</code> est em um formato vlido.
   *  
   * @param value Valor a ser analizado.
   * @return true se estiver em um formato vlido, ou false caso contrrio.
   */
  public boolean isValidValue(String value) {
    if (value == null) {
      throw new IllegalArgumentException(MessageFormat.format(LNG.get(
		  "csbase.logic.algorithms.nullParameter"),
		  "value"));
    }
    if (value.length() == 0) {
      return true;
    }
    switch (type) {
      case STRING:
        return true;
      case DOUBLE:
        try {
          Double.parseDouble(value);
          return true;
        } catch (NumberFormatException exception) {
          return false;
        }
      default:
        return true;
    }
  }
}
