package csbase.logic.algorithms.flows;

import java.io.Serializable;

/**
 * Um ponto no plano.
 *
 * @author lmoreira.
 */
public final class Point implements Serializable, Cloneable {

  /**
   * A abscissa.
   */
  private int x;

  /**
   * A ordenada.
   */
  private int y;

  /**
   * Cria um ponto.
   *
   * @param x A abscissa.
   * @param y A ordenada.
   */
  public Point(int x, int y) {
    setX(x);
    setY(y);
  }

  @Override
  public Point clone() {
    try {
      return (Point) super.clone();
    }
    catch (CloneNotSupportedException e) {
      throw new IllegalStateException(e);
    }
  }
  
  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    Point other = (Point) obj;
    if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
      return false;
    }
    if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
      return false;
    }
    return true;
  }

  /**
   * Obtm a abscissa.
   *
   * @return a abscissa.
   */
  public int getX() {
    return this.x;
  }

  /**
   * Obtm a ordenada.
   *
   * @return a ordenada.
   */
  public int getY() {
    return this.y;
  }

  @Override
  public int hashCode() {
    final int PRIME = 31;
    int result = 1;
    long temp;
    temp = Double.doubleToLongBits(this.x);
    result = PRIME * result + (int) (temp ^ (temp >>> 32));
    temp = Double.doubleToLongBits(this.y);
    result = PRIME * result + (int) (temp ^ (temp >>> 32));
    return result;
  }

  @Override
  public String toString() {
    return "(" + getX() + "; " + getY() + ")";
  }

  /**
   * Atribui a abscissa a este ponto.
   *
   * @param x A abscissa.
   */
  private void setX(int x) {
    this.x = x;
  }

  /**
   * Atribui a ordenada a este ponto.
   *
   * @param y A ordenada.
   */
  private void setY(int y) {
    this.y = y;
  }
}
