package csbase.logic.algorithms.parameters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import tecgraf.javautils.core.lng.LNG;

/**
 * Mtodo chamado via reflexo.
 */
public final class ReflectionExpressionFunction extends ExpressionFunction {

  /** O mtodo a ser chamado. */
  private Method method;

  /**
   * Construtor.
   * 
   * @param method o mtodo.
   */
  public ReflectionExpressionFunction(Method method) {
    super(method.getName(), method.getParameterTypes());
    if (!Modifier.isPublic(method.getModifiers())) {
      String errorMessage =
        MessageFormat.format(LNG.get(
    		"csbase.logic.algorithms.parameters.NonPublicMethod"),
    		method.getName());
      throw new IllegalArgumentException(errorMessage);
    }
    if (!Modifier.isStatic(method.getModifiers())) {
      String errorMessage =
        MessageFormat.format(LNG.get(
    		"csbase.logic.algorithms.parameters.NonStaticMethod"),
    		method.getName());
      throw new IllegalArgumentException(errorMessage);
    }
    this.method = method;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Object doOperation(SimpleAlgorithmConfigurator configurator,
    Object... parameters) throws ExpressionFunctionExecutionException {
    try {
      return this.method.invoke(null, parameters);
    }
    catch (IllegalAccessException e) {
      throw new ExpressionFunctionExecutionException(e);
    }
    catch (InvocationTargetException e) {
      throw new ExpressionFunctionExecutionException(e.getTargetException());
    }
  }
}
