package csbase.logic.algorithms.parsers;

import java.util.Collections;
import java.util.List;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.HiddenParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import tecgraf.javautils.core.lng.LNG;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;

/**
 * <p>
 * Analisador de {@link HiddenParameter}.
 * </p>
 * 
 * <p>
 * Este parser l os atributos de parmetros do tipo oculto. O elemento corrente
 * do {@link XmlParser analisador de XML} precisa ser um elemento
 * {@link HiddenParameter}.
 * </p>
 * 
 */
public class HiddenParameterParser extends ParameterParser implements
  ParameterFactory {

  /**
   * <p>
   * O elemento {@value #HIDDEN_PARAMETER_ELEMENT}: descreve as propriedades de
   * um {@link HiddenParameter parmetro do tipo oculto}.
   * </p>
   * <p>
   *  filho do elemento {@link ParameterGroup}.
   * </p>
   */
  static final String HIDDEN_PARAMETER_ELEMENT = "oculto";

  /**
   * <p>
   * O atributo {@value #HIDDEN_PARAMETER_ELEMENT_VALUE_ATTRIBUTE} do elemento
   * {@link #HIDDEN_PARAMETER_ELEMENT}. Indica o valor do parmetro. 
   * obrigatrio e tipo  string.
   * </p>
   */
  private static final String HIDDEN_PARAMETER_ELEMENT_VALUE_ATTRIBUTE =
    "valor";

  /**
   * {@inheritDoc}
   */
  @Override
  public HiddenParameter createParameter(XmlParser parser,
    String defaultCommandLinePattern, ParameterGroup group,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    String name = parser.extractAttributeValue(
      SimpleParameterParser.PARAMETER_ELEMENT_NAME_ATTRIBUTE);
    String value = parser.extractAttributeValue(
      HIDDEN_PARAMETER_ELEMENT_VALUE_ATTRIBUTE);
    parser.checkAttributes();
    String commandLinePattern = loadCommandLinePattern(parser,
      defaultCommandLinePattern);
    if (commandLinePattern == null) {
      throw new ParseException(LNG.get(
        "csbase.logic.algorithms.parsers.NoCommandPattern"), name, value);
    }
    return new HiddenParameter(name, value, commandLinePattern);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<Class<? extends Parameter>> getParameterTypes() {
    return Collections.singletonList(HiddenParameter.class);
  }

}
