package csbase.logic.algorithms.parsers;

import java.util.ArrayList;
import java.util.List;

import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.Parameter;

/**
 * 
 * <p>
 * Fbrica de parmetros do tipo "arquivo de entrada":
 * {@link InputFileParameter} e {@link InputFileListParameter}. Como esses dois
 * parmetros podem ser criados a partir de uma mesma tag XML, essa fbrica foi
 * criada para direcionar a anlise para o parser apropriado para cada um dos
 * casos.
 * </p>
 * 
 * <p>
 * O elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link InputFileParameterParser#INPUT_FILE_PARAMETER_ELEMENT}.
 * </p>
 * 
 */
public class InputFileParameterFactory extends FileParameterFactory {

  /**
   * Parser do parmetro mltiplo.
   */
  private InputFileListParameterParser fileListParser;

  /**
   * Parser do parmetro simples.
   */
  private InputFileParameterParser fileParser;

  /**
   * Construtor.
   */
  public InputFileParameterFactory() {
    fileParser = new InputFileParameterParser();
    fileListParser = new InputFileListParameterParser();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected InputFileListParameterParser createFileListParser() {
    return fileListParser;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected InputFileParameterParser createSimpleFileParser() {
    return fileParser;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<Class<? extends Parameter>> getParameterTypes() {
    List<Class<? extends Parameter>> types = new ArrayList<>();
    types.addAll(fileParser.getParameterTypes());
    types.addAll(fileListParser.getParameterTypes());
    return types;
  }

}
