package csbase.logic.algorithms.parsers.columns;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleColumn;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parsers.AbstractDoubleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;

/**
 * Fbrica para {@link DoubleColumn}.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class DoubleColumnFactory extends AbstractTableColumnFactory {
  /**
   * <p>
   * O elemento {@value #ELEMENT_NAME}: descreve uma {@link DoubleColumn coluna
   * do tipo real} de um {@link TableParameter parmetro do tipo tabela}.
   * </p>
   */
  private static final String ELEMENT_NAME = "coluna_de_reais";

  /**
   * Cria a fbrica.
   */
  public DoubleColumnFactory() {
    super(ELEMENT_NAME);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setCellValue(XmlParser parser, String parameterName,
    TableColumn<?> column, int rowIndex, String valueAttributeName)
      throws ParseException {
    DoubleColumn doubleColumn = (DoubleColumn) column;
    Double cellValue = parser.extractAttributeValueAsDouble(valueAttributeName,
      null, doubleColumn.getMaximum(), doubleColumn.getMinimum());
    doubleColumn.addDefaultValue(rowIndex, cellValue);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected DoubleColumn createColumn(XmlParser parser, String parameterName,
    String label, String id, boolean isOptional, boolean isEditable,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    Double maximum = parser.extractAttributeValueAsDouble(
      AbstractDoubleParameterParser.DOUBLE_ELEMENT_MAXIMUM_ATTRIBUTE, null,
      null, null);
    boolean isMaximumIncluded = parser.extractAttributeValueAsBoolean(
      AbstractDoubleParameterParser.DOUBLE_ELEMENT_INCLUDE_MAXIMUM_ATTRIBUTE,
      AbstractDoubleParameterParser.DOUBLE_ELEMENT_INCLUDE_MAXIMUM_DEFAULT_VALUE);
    Double minimum = parser.extractAttributeValueAsDouble(
      AbstractDoubleParameterParser.DOUBLE_ELEMENT_MINIMUM_ATTRIBUTE, null,
      maximum, null);
    boolean isMinimumIncluded = parser.extractAttributeValueAsBoolean(
      AbstractDoubleParameterParser.DOUBLE_ELEMENT_INCLUDE_MINIMUM_ATTRIBUTE,
      AbstractDoubleParameterParser.DOUBLE_ELEMENT_INCLUDE_MINIMUM_DEFAULT_VALUE);
    Double defaultValue = parser.extractAttributeValueAsDouble(
      COLUMN_ELEMENT_DEFAULT_VALUE_ATTRIBUTE, null, maximum, minimum);
    parser.checkAttributes();
    parser.checkChildElements();
    return new DoubleColumn(id, label, defaultValue, isOptional, isEditable,
      maximum, isMaximumIncluded, minimum, isMinimumIncluded);
  }
}
