package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.SetVisibleEnumerationItemTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.EnumerationItemFactory;
import csbase.logic.algorithms.parsers.XmlParser;

/**
 * Fbrica de {@link SetVisibleEnumerationItemTrigger}.
 *
 * @author Tecgraf/PUC-Rio
 */
public abstract class SetVisibleEnumerationItemTriggerFactory extends
  AbstractSimpleTriggerFactory {

  /**
   * Atributo {@value #ITEM_ATTRIBUTE}: indica o identificador do
   * {@code EnumerationItem item} que ser manipulado.  obrigatrio.  do tipo
   * string.
   */
  static final String ITEM_ATTRIBUTE = "item";

  /**
   * Indica se  para exibir ({@code true}) ou ocultar ({@code false}).
   */
  private boolean isVisible;

  /**
   * Cria a fbrica.
   *
   * @param elementName O nome do elemento que define as propriedades do
   *        gatilho.
   * @param isVisible Indica se  para exibir ({@code true}) ou ocultar (
   *        {@code false}).
   */
  protected SetVisibleEnumerationItemTriggerFactory(String elementName,
    boolean isVisible) {
    super(elementName, true);
    this.isVisible = isVisible;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected final Trigger<?> doCreateTrigger(XmlParser parser,
    Condition condition, Parameter<?> parameter,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    if (!(parameter instanceof EnumerationParameter)) {
      throw new ParseException(
        "O parmetro {0} no  uma enumerao com seleo simples.", parameter
          .getName(), EnumerationItemFactory.ELEMENT_NAME);
    }
    EnumerationParameter enumerationParameter =
      (EnumerationParameter) parameter;
    String itemId = parser.extractAttributeValue(ITEM_ATTRIBUTE);
    EnumerationItem item = enumerationParameter.getItem(itemId);
    if (item == null) {
      throw new ParseException(
        "No existe um item chamado {1} na enumerao {0}.", parameter, itemId);
    }
    return new SetVisibleEnumerationItemTrigger(enumerationParameter, condition,
      itemId, isVisible);
  }
}
