package csbase.logic.algorithms.validation;

import tecgraf.javautils.core.lng.LNG;

/**
 * Estrutura que encapsula os dados necessrios para a validao de um
 * parmetro.
 * 
 * Informaes como modo de validao ({@link ValidationMode#FULL} ou
 * {@link ValidationMode#ALLOW_EMPY_VALUES}), identificador de projeto e
 * identificador do usurio so necessrias para validar permisses e arquivos
 * existem na rea de projetos.
 * 
 * @author Tecgraf
 */
public class ValidationContext {

  /** Modo em que a validao ser executada. */
  private ValidationMode mode;

  /** Identificador do projeto. */
  private Object projectId;

  /** Identificador do usurio. */
  private Object userId;

  /**
   * Construtor padro.
   * 
   * @param mode modo da validao.
   * @param projectId identificador do projeto.
   * @param userId identificador do usurio.
   */
  public ValidationContext(ValidationMode mode, Object projectId, Object userId) {
    if (mode == null) {
      throw new IllegalArgumentException(LNG.get(
    		  "csbase.logic.algorithms.serializer.NullModeParameter"));
    }
    this.mode = mode;
    this.projectId = projectId;
    this.userId = userId;
  }

  /**
   * Modo da validao.
   * 
   * @return modo.
   */
  public ValidationMode getMode() {
    return mode;
  }

  /**
   * Identificador do projeto.
   * 
   * @return identificador do projeto.
   */
  public Object getProjectId() {
    return projectId;
  }

  /**
   * Identificador do usurio.
   * 
   * @return identificador do usurio.
   */
  public Object getUserId() {
    return userId;
  }

}
