package csbase.logic.diagnosticservice;

import java.io.Serializable;
import java.util.Map;

/**
 * 
 * Informaes estatsticas de login.
 * 
 * @author Tecgraf PUC-Rio
 */
public class LoginStatisticsInfo implements Serializable {
  /**
   * Mapa de logins com sucesso.
   */
  public final Map<String, Integer> succeededLogins;
  /**
   * Mapa de logins com falha.
   */
  public final Map<String, Integer> failedLogins;

  /**
   * Construtor.
   * 
   * @param succeededLogins logins com sucesso
   * @param failedLogins logins com falha de autenticao
   */
  public LoginStatisticsInfo(Map<String, Integer> succeededLogins,
    Map<String, Integer> failedLogins) {
    this.succeededLogins = succeededLogins;
    this.failedLogins = failedLogins;
  }
}
