package csbase.logic.server;

import csbase.remote.RemoteEvent;
import csbase.remote.ServerServiceInterface;
import tecgraf.javautils.core.lng.LNG;

/**
 * Representa um evento gerado pelo {@link ServerServiceInterface servio
 * de servidores}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public abstract class ServerInfoEvent extends RemoteEvent {
  /** O tipo do evento. */
  private ServerInfoEventType type;

  /**
   * Cria um evento de {@ServerInfo}.
   *
   * @param type O tipo do evento.
   *
   * @throws IllegalArgumentException Caso o tipo do evento seja nulo.
   */
  ServerInfoEvent(ServerInfoEventType type) {
    if (type == null) {
      throw new IllegalArgumentException(LNG.get(
    		  "csbase.logic.server.NullServerEvent"));
    }
    this.type = type;
  }

  /**
   * Obtm o tipo do evento.
   *
   * @return O tipo do evento.
   */
  public final ServerInfoEventType getType() {
    return this.type;
  }
}
