package csbase.logic;

/**
 * Enumerao que mapeia os tipos de capacidades definidos na idl com tipos java
 * para que classes do servidor no precisem importar o pacote sgaidl.
 * 
 * @author valeria
 * 
 */
public enum CapacityType {
  /**
   * Constante que representa o benchmark de processamento - CPU
   */
  CPU("CPU"),
  /**
   * Constante que representa o benchmark que mede a taxa de leitura em disco
   */
  DISK_READ("DISK_READ"),
  /**
   * Constante que representa o benchmark que mede a taxa de leitura em disco
   */
  DISK_WRITE("DISK_WRITE"),
  /**
   * Constante que representa o benchmark que mede a taxa de transferncia em
   * rede
   */
  NET("NET");

  /**
   * Tipo
   */
  private final String type;

  /**
   * Construtor.
   * 
   * @param type tipo
   */
  CapacityType(String type) {
    this.type = type;
  }

  /**
   * Consulta o tipo.
   * 
   * @return tipo
   */
  String type() {
    return type;
  }

  /**
   * Mtodo para retornar um tipo de enumerao Java a partir do nome da
   * enumerao obtida da idl.
   * 
   * @param type O nome da enumerao na idl.
   * @return O nome da enumerao Java
   */
  public static CapacityType getType(String type) {
    for (int i = 0; i < values().length; i++) {
      if (values()[i].type.equals(type)) {
        return values()[i];
      }
    }
    return null;
  }
}
