/*
 * $Id$
 */
package csbase.logic;

/**
 * Interface para os ouvintes de uma monitorao. Os ouvintes dessa interface
 * so notificados quando  feito o login ou logout no servidor e quando a
 * conexo com o servidor  perdida ou  reestabelecida.
 * 
 */
public interface MonitoredServerListener {

  /**
   * Mtodo chamado quando a conexo  perdida.
   * 
   * @param serverURI a URI do servidor em questo.
   */
  public void notifyConnectionLost(ServerURI serverURI);

  /**
   * Mtodo chamado quando a conexo  restabelecida.
   * 
   * @param serverURI a URI do servidor em questo.
   */
  public void notifyConnectionReestablished(ServerURI serverURI);

  /**
   * Mtodo chamado quando o login  executado com sucesso
   * 
   * @param serverURI a URI do servidor em questo.
   */
  public void notifyLoggedIn(ServerURI serverURI);

  /**
   * 
   * Mtodo chamado quando o logout  executado com sucesso
   * 
   * @param serverURI a URI do servidor em questo.
   */
  public void notifyLoggedOut(ServerURI serverURI);

}
