/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.FileParameterValue;

/**
 * Parmetro Arquivo de Entrada.
 *
 * @author lmoreira
 */
public class InputFileParameter extends FileParameter {
  /** Texto que representa o tipo desse parmetro */
  public static final String TYPE = "INPUT_FILE";

  /**
   * Cria um parmetro do tipo arquivo de entrada.
   *
   * @param name O nome (No aceita {@code null}).
   * @param label O rtulo (No aceita {@code null}).
   * @param description A descrio do parmetro (No aceita {@code null}).
   * @param defaultValue O valor-padro (Aceita {@code null}).
   * @param isOptional Indica se o parmetro  opcional.
   * @param isVisible Indica se o parmetro deve ficar visvel.
   * @param commandLinePattern O padro para construo da linha de comando. O
   *        padro ser utilizado para escrever o trecho da linha do comando
   *        referente ao parmetro. Esta string ser passada para o mtodo
   *        MessageFormat.format(String,Object...). O primeiro formato ({0}) 
   *        referente ao nome e o segundo formato ({1})  referente ao valor. Se
   *        {@code null} o parmetro no produzir sada na linha de comando.
   * @param type O tipo do arquivo aceito.
   * @param mode O modo de funcionamento do parmetro. ou seleo simples
   *        {@code false}.
   * @param usesPipe Indica se este parmetro pode aceitar pipe
   *        {@value FileParameterPipeAcceptance#TRUE}, no aceita pipe
   *        {@value FileParameterPipeAcceptance#FALSE} ou *s* aceita pipe
   *        {@value FileParameterPipeAcceptance#ALWAYS}.
   * @param usesFilter Indica se um painel para filtro deve ser exibido.
   */
  public InputFileParameter(String name, String label, String description,
    FileParameterValue defaultValue, boolean isOptional, boolean isVisible,
    String commandLinePattern, String type, FileParameterMode mode,
    FileParameterPipeAcceptance usesPipe, boolean usesFilter) {
    super(name, label, description, defaultValue, isOptional, isVisible,
      commandLinePattern, type, mode, usesPipe, usesFilter, true);
  }

  /**
   * (non-Javadoc)
   *
   * @see csbase.logic.algorithms.parameters.SimpleParameter#getType()
   */
  @Override
  public String getType() {
    return TYPE;
  }
}
