package csbase.logic.diagnosticservice;

import java.io.Serializable;

import csbase.logic.UserOutline;

/**
 * Dados bsicos de usurios correntes.
 * 
 * @author Tecgraf
 */
public class UsersBasicInfo implements Serializable {
  /** Nmero de usurios registrados */
  public final int numRegisteredUsers;
  /** Nmero de usurios conectados */
  public final UserOutline[] connectedUsers;

  /**
   * Construtor.
   * 
   * @param numRegisteredUsers nmero de usurios registrados
   * @param connectedUsers usurios conectados
   */
  public UsersBasicInfo(int numRegisteredUsers, UserOutline[] connectedUsers) {
    this.numRegisteredUsers = numRegisteredUsers;
    this.connectedUsers = connectedUsers;
  }
}
