package csbase.logic.filters;

import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileFilter;

/**
 * Define um filtro que no aceita diretrios.
 *
 * @author Rodrigo Carneiro Henrique (rodrigoh)
 */
public final class ProjectFileNotDirectoryFilter implements ProjectFileFilter {
  private static ProjectFileNotDirectoryFilter instance;

  private ProjectFileNotDirectoryFilter() {}

  public static ProjectFileNotDirectoryFilter getInstance() {
    if (ProjectFileNotDirectoryFilter.instance == null) {
      ProjectFileNotDirectoryFilter.instance =
        new ProjectFileNotDirectoryFilter();
    }
    return ProjectFileNotDirectoryFilter.instance;
  }

  public boolean accept(ClientProjectFile file) {
    return (!file.isDirectory());
  }
}
