/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.exception.project.FileLockedException;
import csbase.logic.ClientFile;
import csbase.logic.ClientFileLockListener;
import csbase.logic.ClientFileType;
import csbase.logic.ClientProjectFileInfo;
import csbase.logic.ClientProjectFileList;
import csbase.logic.ProjectFileChannelLoadListener;
import csbase.logic.ProjectFileFilter;
import csbase.logic.ProjectFileInfo;
import csbase.logic.RemoteFileInputStream;
import csbase.logic.RemoteFileOutputStream;
import csbase.logic.SyncRemoteFileChannel;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;

public class ClientProjectFile
implements ClientFile,
Serializable,
Comparable<ClientProjectFile> {
    private transient SyncRemoteFileChannel channel;
    private final Object createdBy;
    private final long creationDate;
    private boolean isDirectory;
    private boolean isUnderConstruction;
    private boolean isLocked;
    private boolean isMoving;
    private long modificationDate;
    private String name;
    private String[] path;
    private int numberOfChannelOpens;
    private ClientProjectFile parent;
    private final Object projectId;
    private ClientProjectFileList children = null;
    private Lock childrenLock = new ReentrantLock();
    private boolean updated;
    private boolean updatable;
    private String updateUserLogin;
    private long updateInterval;
    private long size;
    private boolean opened;
    private String type;
    private boolean hasChildren;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.path[this.path.length - 1] = name;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setModificationDate(long modificationDate) {
        this.modificationDate = modificationDate;
    }

    public Object getProjectId() {
        return this.projectId;
    }

    @Override
    public String getStringPath() {
        String[] pathArray = this.getPath();
        if (pathArray == null || pathArray.length <= 0) {
            return "";
        }
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < pathArray.length - 1; ++i) {
            path.append(pathArray[i]);
            path.append('/');
        }
        return path.append(pathArray[pathArray.length - 1]).toString();
    }

    @Override
    public String[] getPath() {
        return (String[])this.path.clone();
    }

    @Override
    public String getType() {
        return this.type;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public Object whoCreated() {
        return this.createdBy;
    }

    @Override
    public ClientProjectFile getParent() {
        return this.parent;
    }

    public void setParent(ClientProjectFile newParent) {
        this.parent = newParent;
    }

    public void updatePath() throws RemoteException {
        ClientProjectFile[] children;
        if (this.getParent() == null) {
            return;
        }
        String[] parentPath = this.getParent().getPath();
        String[] newPath = new String[parentPath.length + 1];
        for (int n = 0; n < parentPath.length; ++n) {
            newPath[n] = parentPath[n];
        }
        newPath[newPath.length - 1] = this.path[this.path.length - 1];
        this.path = newPath;
        if (this.isDirectory() && (children = this.getChildren()) != null) {
            for (int i = 0; i < children.length; ++i) {
                ClientProjectFile child = children[i];
                child.updatePath();
            }
        }
    }

    public void resetChildren() {
        this.children = null;
    }

    public ClientProjectFile[] getLocalChildren() {
        if (this.children == null) {
            return null;
        }
        return this.children.toArray();
    }

    public ClientProjectFile[] getChildren() throws RemoteException {
        return this.getChildren(false, false);
    }

    ClientProjectFileList getChildrenList() {
        return this.children;
    }

    public ClientProjectFile[] getChildren(boolean discardLocal, boolean recursive) throws RemoteException {
        if (!this.isDirectory()) {
            throw new RemoteException("Arquivo n\u00e3o \u00e9 um diret\u00f3rio");
        }
        this.buildChildListIfNull(discardLocal, recursive);
        return this.children.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildChildListIfNull(boolean discardLocal, boolean recursive) throws RemoteException {
        if (!this.isDirectory()) {
            return;
        }
        this.childrenLock.lock();
        try {
            if (discardLocal || this.children == null) {
                ProjectServiceInterface projectService = ClientRemoteLocator.projectService;
                ClientProjectFile[] newChildren = projectService.getChildren(this.getProjectId(), this.getPath(), recursive);
                this.children = new ClientProjectFileList(this);
                this.children.add(true, true, newChildren);
            }
        }
        finally {
            this.childrenLock.unlock();
        }
    }

    public ClientProjectFile[] getChildren(String fileType) throws RemoteException {
        ClientProjectFile[] myChildren = this.getChildren();
        if (fileType == null) {
            return myChildren;
        }
        ArrayList<ClientProjectFile> aux = new ArrayList<ClientProjectFile>();
        for (ClientProjectFile child : myChildren) {
            if (!child.getType().equals(fileType)) continue;
            aux.add(child);
        }
        return aux.toArray(new ClientProjectFile[aux.size()]);
    }

    public void setChildren(boolean clientSide, boolean fixParentsRecursively, ClientProjectFile[] newChildren) {
        this.children = new ClientProjectFileList(this);
        this.children.add(clientSide, fixParentsRecursively, newChildren);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientProjectFile getChild(String childName) throws RemoteException {
        this.childrenLock.lock();
        try {
            ProjectServiceInterface projectService;
            this.buildChildListIfNull(false, false);
            ClientProjectFile child = this.getChildHelper(childName);
            if (null == child && (child = (projectService = ClientRemoteLocator.projectService).getChild(this.getProjectId(), this.getPath(), childName)) != null && !child.equals(this)) {
                this.children.add(true, true, child);
            }
            ClientProjectFile clientProjectFile = child;
            return clientProjectFile;
        }
        finally {
            this.childrenLock.unlock();
        }
    }

    private ClientProjectFile getChildHelper(String childName) throws RemoteException {
        ClientProjectFile[] myChildren;
        for (ClientProjectFile file : myChildren = this.getChildren()) {
            if (!file.name.equals(childName)) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(boolean clientSide, boolean fixParentsRecursively, ClientProjectFile newChild) throws RemoteException {
        this.buildChildListIfNull(false, false);
        this.childrenLock.lock();
        try {
            this.children.addIfDoesntExist(clientSide, fixParentsRecursively, newChild);
        }
        finally {
            this.childrenLock.unlock();
        }
    }

    public int getChildIndex(ClientProjectFile child) throws RemoteException {
        ClientProjectFile[] myChildren = this.getChildren();
        int sz = myChildren.length;
        for (int i = 0; i < sz; ++i) {
            ClientProjectFile file = myChildren[i];
            if (!child.equals(file)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeChild(ClientProjectFile child) throws RemoteException {
        this.buildChildListIfNull(false, false);
        this.childrenLock.lock();
        try {
            int n = this.children.remove(child);
            return n;
        }
        finally {
            this.childrenLock.unlock();
        }
    }

    public void createDirectory(String dirName) throws RemoteException {
        ClientRemoteLocator.projectService.createDirectory(this.projectId, this.getPath(), dirName);
    }

    public void createFile(String fileName, String fileType) throws RemoteException {
        ClientRemoteLocator.projectService.createFile(this.projectId, this.getPath(), fileName, fileType);
    }

    public void createFiles(List<ProjectFileInfo> fileInfoList) throws RemoteException {
        ClientRemoteLocator.projectService.createFiles(this.projectId, this.getPath(), fileInfoList);
    }

    public void rename(String fileName) throws RemoteException {
        ClientRemoteLocator.projectService.renameFile(this.projectId, this.getPath(), fileName);
    }

    public void copy(ClientProjectFile directory) throws RemoteException {
        Object sourceProjectId;
        Object targetProjectId = directory.getProjectId();
        if (targetProjectId.equals(sourceProjectId = this.projectId)) {
            ClientRemoteLocator.projectService.copyFile(sourceProjectId, this.getPath(), directory.getPath());
        } else {
            ClientRemoteLocator.projectService.copyFile(sourceProjectId, this.getPath(), targetProjectId, directory.getPath());
        }
    }

    public void move(ClientProjectFile directory) throws RemoteException {
        Object sourceProjectId;
        Object targetProjectId = directory.getProjectId();
        if (targetProjectId.equals(sourceProjectId = this.projectId)) {
            ClientRemoteLocator.projectService.moveFile(this.projectId, this.getPath(), directory.getPath());
        } else {
            ClientRemoteLocator.projectService.moveFile(sourceProjectId, this.getPath(), targetProjectId, directory.getPath());
        }
    }

    public void remove() throws RemoteException {
        ClientRemoteLocator.projectService.removeFile(this.projectId, this.getPath());
    }

    public void updateInfo() throws RemoteException {
        ClientProjectFileInfo info = ClientRemoteLocator.projectService.getUpdatedFileInfo(this.projectId, this.getPath());
        this.type = info.getType();
        this.size = info.getSize();
        this.modificationDate = info.getModificationDate();
        this.isUnderConstruction = info.isUnderConstruction();
        this.isLocked = info.isLocked();
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public boolean isUnderConstruction() {
        return this.isUnderConstruction;
    }

    public void setUnderConstruction(boolean isUnderConstruction) {
        this.isUnderConstruction = isUnderConstruction;
    }

    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    public String getDescription() throws RemoteException {
        return ClientRemoteLocator.projectService.getFileDescription(this.projectId, this.getPath());
    }

    public void setDescription(String text) throws RemoteException {
        ClientRemoteLocator.projectService.setFileDescription(this.projectId, this.getPath(), text);
    }

    public void appendDescription(String text) throws RemoteException {
        ClientRemoteLocator.projectService.appendFileDescription(this.projectId, this.getPath(), text);
    }

    @Override
    public long size() {
        return this.size;
    }

    public long getTotalSize(ProjectFileFilter filter) throws RemoteException {
        if (this.isDirectory()) {
            this.getChildren(true, true);
            return this.getLocalTotalSize(filter);
        }
        return this.size();
    }

    public long getLocalTotalSize(ProjectFileFilter filter) {
        long transferSize = 0L;
        if (this.isDirectory()) {
            transferSize = this.size();
            ClientProjectFile[] myChildren = this.getLocalChildren();
            if (myChildren != null) {
                for (ClientProjectFile child : myChildren) {
                    if (filter != null && !filter.accept(child)) continue;
                    transferSize += child.getLocalTotalSize(filter);
                }
            }
        } else {
            transferSize = this.size();
        }
        return transferSize;
    }

    @Override
    public long getModificationDate() {
        return this.modificationDate;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public ClientProjectFile getChild(String[] path) throws RemoteException {
        if (path == null || path.length == 0) {
            return null;
        }
        if (!this.isDirectory) {
            return null;
        }
        ClientProjectFile child = this;
        for (int i = 0; i < path.length; ++i) {
            if ((child = child.getChild(path[i])) != null) continue;
            return null;
        }
        return child;
    }

    public ClientProjectFile getChild(ProjectFileInfo prjFileInfo) throws RemoteException {
        return this.getChild(prjFileInfo.getPath());
    }

    @Override
    public boolean exists() throws RemoteException {
        return ClientProjectFile.existsFile(this.projectId, this.getPath());
    }

    public static boolean existsFile(Object projectId, String[] path) throws RemoteException {
        return ClientRemoteLocator.projectService.existsFile(projectId, path);
    }

    public static String[] splitPath(String path) {
        int i;
        String[] pathArray = path.split("/");
        for (i = 0; i < pathArray.length && pathArray[i].equals(""); ++i) {
        }
        if (i > 0) {
            String[] newPath = new String[pathArray.length - i];
            System.arraycopy(pathArray, i, newPath, 0, newPath.length);
            pathArray = newPath;
        }
        return pathArray;
    }

    public void truncate(long newSize) throws IOException {
        try {
            this.channel.setSize(newSize);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private SyncRemoteFileChannel openChannel(boolean readOnly) throws RemoteException {
        RemoteFileChannelInfo info = ClientRemoteLocator.projectService.openFileChannel(this.projectId, this.getPath(), readOnly);
        SyncRemoteFileChannel srfc = new SyncRemoteFileChannel(info.getIdentifier(), info.isWritable(), info.getHost(), info.getPort(), info.getKey());
        try {
            srfc.open(readOnly);
            return srfc;
        }
        catch (Exception e) {
            this.channel = null;
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public void open(boolean readOnly) throws RemoteException {
        this.updateInfo();
        if (!this.opened) {
            this.channel = this.openChannel(readOnly);
            this.numberOfChannelOpens = 1;
            this.opened = true;
        } else {
            ++this.numberOfChannelOpens;
        }
    }

    public Object acquireExclusiveLock() throws RemoteException {
        return ClientRemoteLocator.projectService.acquireExclusiveLock(this.getProjectId(), this.getPath());
    }

    public Object acquireExclusiveLock(ClientFileLockListener listener, long timeout) throws RemoteException {
        return ClientRemoteLocator.projectService.acquireExclusiveLock(this.getProjectId(), this.getPath(), listener, timeout);
    }

    public Object acquireSharedLock() throws RemoteException {
        return ClientRemoteLocator.projectService.acquireSharedLock(this.getProjectId(), this.getPath());
    }

    public Object acquireSharedLock(ClientFileLockListener listener, long timeout) throws RemoteException {
        return ClientRemoteLocator.projectService.acquireSharedLock(this.getProjectId(), this.getPath(), listener, timeout);
    }

    public int releaseLock(Object lockId) throws RemoteException {
        return ClientRemoteLocator.projectService.releaseLock(this.getProjectId(), this.getPath(), lockId);
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean userOwnsLock() throws RemoteException {
        return ClientRemoteLocator.projectService.userOwnsLock(this.getProjectId(), this.getPath());
    }

    public boolean isOpen() {
        return this.opened;
    }

    @Override
    public long position() {
        return this.channel.getPosition();
    }

    @Override
    public void position(long newPosition) throws IOException {
        try {
            this.channel.setPosition(newPosition);
        }
        catch (FailureException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public int read(byte[] dst, long position) throws IOException {
        try {
            int length = (int)Math.min((long)dst.length, this.channel.getSize() - position);
            return this.channel.syncRead(dst, 0, length, position);
        }
        catch (FailureException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public int read(byte[] target, int offset, int length, long position) throws IOException {
        try {
            length = (int)Math.min((long)length, this.channel.getSize() - position);
            return this.channel.read(target, offset, length, position);
        }
        catch (FailureException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void write(byte[] src, long position) throws IOException, FileLockedException {
        try {
            this.channel.syncWrite(src, 0, src.length, position);
        }
        catch (tecgraf.ftc.common.exception.FileLockedException e) {
            throw new FileLockedException(this.getName(), this.isDirectory());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void write(byte[] src, int off, int len, long position) throws IOException, FileLockedException {
        try {
            this.channel.syncWrite(src, off, len, position);
        }
        catch (tecgraf.ftc.common.exception.FileLockedException e) {
            throw new FileLockedException(this.getName(), this.isDirectory());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void upload(InputStream in, long chunkSize, ProjectFileChannelLoadListener listener) throws IOException, FileLockedException {
        this.open(false);
        try {
            long transfered = 0L;
            while (true) {
                long part;
                try {
                    part = this.channel.syncTransferFrom(in, transfered, chunkSize);
                    if (part < chunkSize) {
                        return;
                    }
                }
                catch (tecgraf.ftc.common.exception.FileLockedException e) {
                    throw new FileLockedException(this.name, this.isDirectory);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage(), e);
                }
                {
                    transfered += part;
                    if (listener == null) continue;
                    listener.transferedBytes(transfered, part);
                    continue;
                }
                break;
            }
        }
        finally {
            this.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void download(OutputStream out, long chunkSize, ProjectFileChannelLoadListener listener) throws IOException {
        this.open(true);
        try {
            long part;
            long size = this.channel.getSize();
            for (long transfered = 0L; transfered < size; transfered += part) {
                try {
                    part = this.channel.syncTransferTo(transfered, chunkSize, out);
                    if (listener == null) continue;
                    listener.transferedBytes(transfered, part);
                    continue;
                }
                catch (Exception e) {
                    throw new RemoteException(e.getMessage(), e);
                    return;
                }
            }
        }
        finally {
            this.close(false);
        }
    }

    @Override
    public void close(boolean force) throws RemoteException, IOException {
        if (this.opened && --this.numberOfChannelOpens == 0) {
            try {
                this.channel.close();
                this.channel = null;
                this.opened = false;
            }
            catch (FailureException e) {
                if (force) {
                    this.channel = null;
                    this.opened = false;
                }
                throw new RemoteException(e.getMessage(), e);
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public void changeType(String newType) throws RemoteException {
        ClientRemoteLocator.projectService.changeFileType(this.projectId, this.getPath(), newType);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ClientProjectFile other = (ClientProjectFile)o;
        return this.projectId.equals(other.projectId) && Arrays.equals(this.path, other.path);
    }

    public int hashCode() {
        int hash = this.projectId.hashCode();
        for (String part : this.path) {
            hash += part.hashCode();
        }
        return hash;
    }

    public ClientProjectFile(Object projectId, String name, String[] path, ClientProjectFile parent, String type, boolean isDirectory, boolean hasChildren, boolean isUnderConstruction, Object createdBy, long creationDate, long size, long modificationDate, boolean isLocked, boolean updatable, String updateUserLogin, long updateInterval) {
        this.projectId = projectId;
        this.name = name;
        this.path = path;
        this.parent = parent;
        this.type = type;
        this.isDirectory = isDirectory;
        this.hasChildren = hasChildren;
        this.isLocked = isLocked;
        this.isUnderConstruction = isUnderConstruction;
        this.channel = null;
        this.opened = false;
        this.numberOfChannelOpens = 0;
        this.createdBy = createdBy;
        this.creationDate = creationDate;
        this.size = size;
        this.modificationDate = modificationDate;
        this.updated = true;
        this.updatable = updatable;
        this.updateUserLogin = updateUserLogin;
        this.updateInterval = updateInterval;
    }

    @Override
    public int compareTo(ClientProjectFile other) {
        return this.name.compareTo(other.name);
    }

    public void setMoving(boolean isMoving) {
        if (this.isMoving != isMoving) {
            this.isMoving = isMoving;
        }
    }

    public boolean isMoving() {
        return this.isMoving || null != this.getParent() && this.getParent().isMoving();
    }

    public static boolean hasDirectories(ClientProjectFile[] projectFiles) {
        for (int i = 0; i < projectFiles.length; ++i) {
            if (!projectFiles[i].isDirectory()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFileUnderConstruction(ClientProjectFile[] projectFiles) {
        for (int i = 0; i < projectFiles.length; ++i) {
            if (!projectFiles[i].isUnderConstruction()) continue;
            return true;
        }
        return false;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public String getUpdateUserLogin() {
        return this.updateUserLogin;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInfo(String updateUserLogin, long updateInterval) {
        this.updateUserLogin = updateUserLogin;
        this.updateInterval = updateInterval;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        SyncRemoteFileChannel srfc = this.openChannel(true);
        String id = this.projectId.toString() + "/" + this.getStringPath();
        return new RemoteFileInputStream(id.getBytes(), srfc);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        SyncRemoteFileChannel srfc = this.openChannel(false);
        String id = this.projectId.toString() + "/" + this.getStringPath();
        return new RemoteFileOutputStream(id.getBytes(), srfc);
    }

    @Override
    public ClientFileType getClientFileType() {
        return ClientFileType.REMOTE;
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }
}

