/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import csbase.logic.AlgoEvent;
import csbase.logic.algorithms.AlgorithmOutline;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class AlgorithmInfo
implements Serializable,
Comparable<AlgorithmInfo> {
    public static final int MAX_NAME_SIZE = 50;
    public static final String VERSIONS_DIR = "versions";
    private String id;
    private String dir;
    private String name;
    private String description;
    private Hashtable<AlgorithmVersionId, AlgorithmVersionInfo> versions;
    public static final String PROPERTY_VALUES_FILE = "algorithm.properties";
    public static final String HIDE_ALGORITHM_PROPERTY = "ocultar";
    public static final String HIDE_ALGORITHM_VALUE = "sim";
    public static final String OWNER_ALGORITHM_PROPERTY = "criador";
    private Hashtable<String, String> propertyValues;
    private String algorithmRepositoryPath;
    private List<String> categoryFullNames;
    private static Observable observable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };

    public AlgorithmInfo(String id, String name, String dir, String algorithmRepositoryPath, Hashtable<String, String> propertyValues) {
        this(id, name, dir, algorithmRepositoryPath, propertyValues, new Hashtable<AlgorithmVersionId, AlgorithmVersionInfo>());
    }

    public AlgorithmInfo(String id, String name, String dir, String algorithmRepositoryPath, Hashtable<String, String> propertyValues, Hashtable<AlgorithmVersionId, AlgorithmVersionInfo> versions) {
        this.id = id;
        this.name = name;
        this.dir = dir;
        this.versions = versions;
        this.propertyValues = propertyValues;
        this.algorithmRepositoryPath = algorithmRepositoryPath;
    }

    public AlgorithmInfo(AlgorithmInfo algorithmInfo) {
        this(algorithmInfo.getId(), algorithmInfo.getName(), algorithmInfo.getDirectory(), algorithmInfo.getAlgorithmRepositoryPath(), algorithmInfo.getPropertyValues(), algorithmInfo.getAllVersionInfo());
    }

    public static void addObserver(Observer o) {
        observable.addObserver(o);
    }

    public static void deleteObserver(Observer o) {
        observable.deleteObserver(o);
    }

    public String getAlgorithmRepositoryPath() {
        return this.algorithmRepositoryPath;
    }

    public static AlgorithmInfo getAlgorithmInfo(String name) throws Exception {
        AlgorithmInfo algoInfo = null;
        if (name != null) {
            algoInfo = ClientRemoteLocator.algorithmService.getInfo(name);
        }
        return algoInfo;
    }

    public static AlgorithmInfo getAlgorithmInfo(Object id) throws Exception {
        AlgorithmInfo algoInfo = null;
        if (id != null) {
            algoInfo = ClientRemoteLocator.algorithmService.getInfo(id);
        }
        return algoInfo;
    }

    public static void update(AlgoEvent event) throws Exception {
        observable.notifyObservers(event);
    }

    @Override
    public int compareTo(AlgorithmInfo o) {
        return this.name.compareToIgnoreCase(o.name);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AlgorithmInfo)) {
            return false;
        }
        AlgorithmInfo algorithmInfo = (AlgorithmInfo)object;
        return algorithmInfo.getId().equals(this.getId());
    }

    public String getDirectory() {
        return this.dir;
    }

    public String getId() {
        return this.id;
    }

    public AlgorithmVersionInfo getLastVersion() {
        if (this.versions.isEmpty()) {
            return null;
        }
        Iterator<AlgorithmVersionInfo> versionIterator = this.versions.values().iterator();
        AlgorithmVersionInfo lastVersion = versionIterator.next();
        while (versionIterator.hasNext()) {
            AlgorithmVersionInfo currentVersion = versionIterator.next();
            if (currentVersion.compareTo(lastVersion) >= 0) continue;
            lastVersion = currentVersion;
        }
        return lastVersion;
    }

    public String getName() {
        return this.name;
    }

    public AlgorithmOutline getOutline() {
        return new AlgorithmOutline(this.id, this.name);
    }

    public Object[] getVersionIds() {
        if (this.versions.size() == 0) {
            return null;
        }
        Object[] allInfo = this.versions.values().toArray();
        Object[] send = new Object[allInfo.length];
        for (int i = 0; i < allInfo.length; ++i) {
            send[i] = ((AlgorithmVersionInfo)allInfo[i]).getId();
        }
        return send;
    }

    public AlgorithmVersionInfo getVersionInfo(Object versionId) {
        if (versionId == null) {
            return null;
        }
        return this.versions.get(versionId);
    }

    public String getVersionsDirName() {
        return VERSIONS_DIR;
    }

    public Vector<AlgorithmVersionInfo> getVersions() {
        return new Vector<AlgorithmVersionInfo>(this.versions.values());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.name;
    }

    protected void deleteVersion(Object versionId) {
        this.versions.remove(versionId);
    }

    protected Hashtable<AlgorithmVersionId, AlgorithmVersionInfo> getAllVersionInfo() {
        return this.versions;
    }

    protected void includeVersion(AlgorithmVersionId versionId, AlgorithmVersionInfo vInfo) {
        this.versions.put(versionId, vInfo);
    }

    public String getPropertyValue(String propertyName) {
        String result = this.propertyValues.get(propertyName);
        if (result == null || result.length() == 0) {
            return null;
        }
        return result;
    }

    public Hashtable<String, String> getPropertyValues() {
        return this.propertyValues;
    }

    public void setPropertyValues(Hashtable<String, String> atributeValues) {
        this.propertyValues = atributeValues;
    }

    public String getOwner() {
        return this.getPropertyValue(OWNER_ALGORITHM_PROPERTY);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setAlgoPackCategoryFullNames(List<String> categoryFullNames) {
        this.categoryFullNames = categoryFullNames;
    }

    public List<String> getAlgoPackCategoryFullNames() {
        return this.categoryFullNames;
    }

    static {
        RestartManager.getInstance().addListener(new RestartListener(){

            public void restart() {
                observable.deleteObservers();
            }
        });
    }
}

