/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.flows;

import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.flows.FlowLink;
import csbase.logic.algorithms.flows.FlowNode;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import tecgraf.javautils.core.io.FileUtils;

public final class Flow
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private Set<FlowLink> links;
    private Set<FlowNode> nodes;

    public Flow(String name, String description, Set<FlowNode> nodes, Set<FlowLink> links) {
        this.name = name;
        this.description = description;
        this.setLinks(links);
        this.setNodes(nodes);
    }

    private String formatFilePathForNode(String file, int nodeId) {
        String formattedFilename;
        String extension = FileUtils.getFileExtension((String)file);
        String filePath = FileUtils.getFilePath((String)file);
        if (extension != null) {
            String fileWithExtension = FileUtils.getFileName((String)file);
            String filename = fileWithExtension.substring(0, fileWithExtension.lastIndexOf(extension) - 1);
            formattedFilename = String.format("%s/%s%s.%s", filePath, filename, nodeId, extension);
        } else {
            formattedFilename = String.format("%s%s", file, nodeId);
        }
        return formattedFilename;
    }

    public void setStandardOutputFile(FileParameterValue standardOutputFile) {
        String stdOutPath = standardOutputFile.getPath();
        String type = standardOutputFile.getType();
        for (FlowNode node : this.nodes) {
            int nodeId = node.getId();
            String nodeStdOutPath = this.formatFilePathForNode(stdOutPath, nodeId);
            FileParameterValue nodeStdOut = new FileParameterValue(nodeStdOutPath, type);
            node.setStandardOutputFile(nodeStdOut);
        }
    }

    public Set<FileParameterValue> getStandardOutputFiles() {
        HashSet<FileParameterValue> stdouts = new HashSet<FileParameterValue>();
        for (FlowNode node : this.nodes) {
            if (node.isBypassed() || null == node.getStandardOutputFile()) continue;
            stdouts.add(node.getStandardOutputFile());
        }
        return Collections.unmodifiableSet(stdouts);
    }

    public Flow clone() {
        try {
            Flow clone = (Flow)super.clone();
            clone.name = this.name;
            clone.description = this.description;
            clone.links = new HashSet<FlowLink>();
            for (FlowLink flowLink : this.links) {
                clone.links.add(flowLink.clone());
            }
            clone.nodes = new HashSet<FlowNode>();
            for (FlowNode flowNode : this.nodes) {
                clone.nodes.add(flowNode.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public Set<FlowLink> getLinks() {
        return Collections.unmodifiableSet(this.links);
    }

    public String getName() {
        return this.name;
    }

    public FlowNode getNode(int nodeId) {
        for (FlowNode node : this.nodes) {
            if (node.getId() != nodeId) continue;
            return node;
        }
        return null;
    }

    public Set<FlowNode> getNodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    private void setLinks(Set<FlowLink> links) {
        if (links == null) {
            throw new IllegalArgumentException("O par\u00e2metro links est\u00e1 nulo.");
        }
        this.links = new HashSet<FlowLink>(links);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("O par\u00e2metro name est\u00e1 nulo.");
        }
        this.name = name;
    }

    private void setNodes(Set<FlowNode> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("O par\u00e2metro nodes est\u00e1 nulo.");
        }
        this.nodes = new HashSet<FlowNode>(nodes);
    }

    public void setExitCodeLogFile(FileParameterValue exitCodeLogFile) {
        String exitCodeFilePath = exitCodeLogFile.getPath();
        String type = exitCodeLogFile.getType();
        for (FlowNode node : this.nodes) {
            int nodeId = node.getId();
            String nodeExitCodeFilePath = this.formatFilePathForNode(exitCodeFilePath, nodeId);
            FileParameterValue nodeExitCodeFile = new FileParameterValue(nodeExitCodeFilePath, type);
            if (!node.hasExitCode()) continue;
            node.setExitCodeLogFile(nodeExitCodeFile);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<FileParameterValue> getExitCodeLogFiles() {
        HashSet<FileParameterValue> exitCodeFiles = new HashSet<FileParameterValue>();
        for (FlowNode node : this.nodes) {
            if (!node.hasExitCode() || node.getExitCodeLogFile() == null) continue;
            exitCodeFiles.add(node.getExitCodeLogFile());
        }
        return Collections.unmodifiableSet(exitCodeFiles);
    }

    public boolean hasExitCode() {
        for (FlowNode node : this.nodes) {
            if (!node.hasExitCode()) continue;
            return true;
        }
        return false;
    }
}

