/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.AccessSGAPathPermission;
import csbase.logic.ClientSGAFile;
import csbase.logic.SGASet;
import csbase.logic.User;
import csbase.logic.algorithms.parameters.ClientSGAFileParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.FileParameterValidator;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationSuccess;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SGAServiceInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class ClientSGAFileValidator
extends SimpleParameterValidator<ClientSGAFile> {
    public ClientSGAFileValidator(boolean isOptional) {
        super(isOptional);
    }

    @Override
    public Validation validateValue(SimpleParameter<?> parameter, ClientSGAFile value, ValidationContext context) throws RemoteException {
        Validation result = super.validateValue(parameter, value, context);
        if (!result.isWellSucceded()) {
            return result;
        }
        ClientSGAFileParameter param = (ClientSGAFileParameter)parameter;
        if (value != null) {
            result = this.validateSGA(param, value);
            if (!result.isWellSucceded()) {
                return result;
            }
            if (!param.isMultipleSelection() && !(result = this.validateFileOrDir(param, value)).isWellSucceded()) {
                return result;
            }
            result = this.validateMultipleSelection(param, value);
            if (!result.isWellSucceded()) {
                return result;
            }
            result = this.validatePathsFormat(param, value);
            if (!result.isWellSucceded()) {
                return result;
            }
            if (param.isInputMode() && !(result = this.validatePermissions(param, value, context)).isWellSucceded()) {
                return result;
            }
        }
        return new ValidationSuccess();
    }

    private Validation validateSGA(ClientSGAFileParameter parameter, ClientSGAFile value) throws RemoteException {
        SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        SGASet sgaSet = sgaService.getSGASet(value.getSGAName());
        if (sgaSet == null) {
            LocalizedMessage message = new LocalizedMessage(ClientSGAFileValidator.class, "sga.not.found", new Object[]{value.getSGAName()});
            return new ValidationError(message);
        }
        if (!sgaSet.getAlive()) {
            LocalizedMessage message = new LocalizedMessage(ClientSGAFileValidator.class, "sga.not.alive", new Object[]{value.getSGAName()});
            return new ValidationError(message);
        }
        return new ValidationSuccess();
    }

    private Validation validateFileOrDir(ClientSGAFileParameter parameter, ClientSGAFile value) {
        boolean onlyFiles = parameter.isShowFiles();
        ArrayList<ClientSGAFile> files = new ArrayList<ClientSGAFile>();
        files.add(value);
        files.addAll(value.getBrothers());
        for (ClientSGAFile file : files) {
            if (onlyFiles) {
                if (!file.isDir()) continue;
                LocalizedMessage message = new LocalizedMessage(ClientSGAFileValidator.class, "should.be.file", new Object[]{file.getSGAName(), file.getStringPath()});
                return new ValidationError(message);
            }
            if (file.isDir()) continue;
            LocalizedMessage message = new LocalizedMessage(ClientSGAFileValidator.class, "should.be.directory", new Object[]{file.getSGAName(), file.getStringPath()});
            return new ValidationError(message);
        }
        return new ValidationSuccess();
    }

    private Validation validateMultipleSelection(ClientSGAFileParameter parameter, ClientSGAFile value) {
        if (!parameter.isMultipleSelection() && !value.getBrothers().isEmpty()) {
            LocalizedMessage message = new LocalizedMessage(ClientSGAFileValidator.class, "only.one", new Object[]{value.getSGAName()});
            return new ValidationError(message);
        }
        return new ValidationSuccess();
    }

    private Validation validatePathsFormat(ClientSGAFileParameter parameter, ClientSGAFile value) {
        ArrayList<ClientSGAFile> files = new ArrayList<ClientSGAFile>();
        files.add(value);
        files.addAll(value.getBrothers());
        for (ClientSGAFile file : files) {
            Validation result = FileParameterValidator.validateFileName(file.getPath());
            if (!result.isWellSucceded()) {
                return result;
            }
            if (file.canRead()) continue;
            LocalizedMessage message = new LocalizedMessage(ClientSGAFileValidator.class, "sga.cannot.read", new Object[]{file.getName()});
            return new ValidationError(message);
        }
        return new ValidationSuccess();
    }

    private Validation validatePermissions(ClientSGAFileParameter parameter, ClientSGAFile value, ValidationContext context) throws RemoteException {
        ArrayList<ClientSGAFile> files = new ArrayList<ClientSGAFile>();
        files.add(value);
        files.addAll(value.getBrothers());
        User user = User.getUser(context.getUserId());
        for (ClientSGAFile file : files) {
            if (file.canRead() && AccessSGAPathPermission.canReadPath(user, file.getSGAName(), file.getStringPath())) continue;
            LocalizedMessage message = new LocalizedMessage(ClientSGAFileValidator.class, "sga.cannot.read", new Object[]{file.getSGAName(), file.getStringPath()});
            return new ValidationError(message);
        }
        return new ValidationSuccess();
    }
}

