/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.URLListParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLValue;
import csbase.logic.algorithms.parameters.validators.ListParameterValidator;
import csbase.logic.algorithms.parameters.validators.URLParameterValidator;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.logic.algorithms.validation.ValidationSuccess;
import java.rmi.RemoteException;
import java.util.List;

public final class URLListParameterValidator
extends ListParameterValidator<URLValue> {
    public URLListParameterValidator(URLParameterValidator urlValidator) {
        super(urlValidator);
    }

    @Override
    public final Validation validateValue(SimpleParameter<?> parameter, List<URLValue> values, ValidationContext context) throws RemoteException {
        if (!parameter.isVisible() || !parameter.isEnabled()) {
            return new ValidationSuccess();
        }
        if (values == null || values.isEmpty()) {
            if (this.isOptional() || this.getMode().equals((Object)ValidationMode.ALLOW_EMPY_VALUES)) {
                return new ValidationSuccess();
            }
            LocalizedMessage message = new LocalizedMessage(ListParameterValidator.class, "empty_value", new Object[]{parameter.getLabel()});
            return new ValidationError(message);
        }
        URLListParameter urlListParameter = (URLListParameter)parameter;
        URLProtocol protocol = values.iterator().next().getProtocol();
        for (URLValue url : values) {
            if (protocol != url.getProtocol()) {
                LocalizedMessage message = new LocalizedMessage(URLListParameterValidator.class, "multiple_protocol", new Object[]{parameter.getLabel()});
                return new ValidationError(message);
            }
            URLParameterValidator validator = this.getItemValidator();
            Validation result = validator.validateURL(url, urlListParameter.getAllowedProtocols(), urlListParameter.mustExist(), urlListParameter.getMode(), context);
            if (result.isWellSucceded()) continue;
            return result;
        }
        return new ValidationSuccess();
    }

    public URLParameterValidator getItemValidator() {
        return (URLParameterValidator)super.getItemValidator();
    }
}

