/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;

public abstract class AbstractDoubleParameterParser<T extends SimpleParameter<?>>
extends SimpleParameterParser<T> {
    static final String DOUBLE_ELEMENT_INCLUDE_MAXIMUM_ATTRIBUTE = "incluir_maximo";
    static final boolean DOUBLE_ELEMENT_INCLUDE_MAXIMUM_DEFAULT_VALUE = true;
    static final String DOUBLE_ELEMENT_INCLUDE_MINIMUM_ATTRIBUTE = "incluir_minimo";
    static final boolean DOUBLE_ELEMENT_INCLUDE_MINIMUM_DEFAULT_VALUE = true;
    static final String DOUBLE_ELEMENT_MAXIMUM_ATTRIBUTE = "maximo";
    static final String DOUBLE_ELEMENT_MINIMUM_ATTRIBUTE = "minimo";

    @Override
    public T createSimpleParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, ParameterGroup group) throws ParseException {
        Double maximum = parser.extractAttributeValueAsDouble(DOUBLE_ELEMENT_MAXIMUM_ATTRIBUTE, null, null, null);
        boolean isMaximumIncluded = parser.extractAttributeValueAsBoolean(DOUBLE_ELEMENT_INCLUDE_MAXIMUM_ATTRIBUTE, true);
        Double minimum = parser.extractAttributeValueAsDouble(DOUBLE_ELEMENT_MINIMUM_ATTRIBUTE, null, maximum, null);
        boolean isMinimumIncluded = parser.extractAttributeValueAsBoolean(DOUBLE_ELEMENT_INCLUDE_MINIMUM_ATTRIBUTE, true);
        return this.createDoubleParameter(parser, name, label, description, isOptional, isVisible, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
    }

    protected abstract T createDoubleParameter(XmlParser var1, String var2, String var3, String var4, boolean var5, boolean var6, String var7, Double var8, boolean var9, Double var10, boolean var11) throws ParseException;
}

