/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parsers.AbstractFileParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;

public class InputFileParameterParser
extends AbstractFileParameterParser<InputFileParameter> {
    static final String INPUT_FILE_PARAMETER_ELEMENT = "arquivo_de_entrada";

    @Override
    public InputFileParameter createFileParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, String type) throws ParseException {
        boolean mustSort;
        boolean sortDefined = parser.hasAttributeValue("ordenar");
        if (sortDefined && (mustSort = parser.extractAttributeValueAsBoolean("ordenar", true))) {
            throw new ParseException("Arquivo de entrada (sele\u00e7\u00e3o \u00fanica) n\u00e3o admite atributo: ordenar");
        }
        FileParameterPipeAcceptance usesPipe = parser.extractAttributeValueAsEnumeration("permitir_pipe", FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_DEFAULT_VALUE, new AbstractFileParameterParser.FileParameterPipeAcceptanceConverter());
        String modeName = parser.extractAttributeValue("categoria", "arquivo");
        FileParameterMode mode = null;
        if (modeName.equals("diretorio")) {
            mode = FileParameterMode.DIRECTORY;
        } else if (modeName.equals("ambos")) {
            mode = FileParameterMode.DIRECTORY_AND_REGULAR_FILE;
        } else if (modeName.equals("arquivo")) {
            mode = FileParameterMode.REGULAR_FILE;
        } else {
            throw new ParseException("A categoria informada {0} n\u00e3o \u00e9 v\u00e1lida.\nCategorias v\u00e1lidas:\n{1};\n{2};{3}.", modeName, "arquivo", "diretorio", "ambos");
        }
        boolean useRootDirectoryAsDefault = parser.extractAttributeValueAsBoolean("usar_diretorio_raiz_como_padrao", false);
        FileParameterValue defaultValue = null;
        if (useRootDirectoryAsDefault) {
            if (mode == FileParameterMode.REGULAR_FILE) {
                throw new ParseException("O atributo {0} \u00e9 inv\u00e1lido quando o par\u00e2metro de entrada \u00e9 um arquivo.", "usar_diretorio_raiz_como_padrao");
            }
            defaultValue = new FileParameterValue(".");
        }
        boolean useFilter = parser.extractAttributeValueAsBoolean("usar_filtro", false);
        InputFileParameter parameter = new InputFileParameter(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, type, mode, usesPipe, useFilter);
        return parameter;
    }
}

