/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parsers.StringToEnumConverter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlParser {
    private final String error_check_attributes = "Alguns atributos do elemento {0} n\u00e3o foram processados.\nAtributos:\n{1}";
    private final String error_check_child_elements = "Alguns elementos filhos do elemento {0} n\u00e3o foram processados.\nElementos-filhos:\n{1}";
    private final String error_configuration = "Erro nas configura\u00e7\u00f5es do parser.";
    private final String error_syntax = "Erro de sintaxe no arquivo.\nDetalhes: {0}.";
    private final String error_io = "Erro de IO ao ler o arquivo.";
    private final String error_wrong_element = "Foi encontrado o elemento {0}, por\u00e9m era esperado o elemento {1}.";
    private final String error_attribute_not_found = "O atributo {1} do elemento {0} n\u00e3o foi encontrado.";
    private final String error_attribute_not_boolean = "O valor {1} do atributo {0} n\u00e3o \u00e9 do tipo booleano.";
    private final String error_attribute_not_double = "O valor do atributo {1} do elemento {0} deveria ser um n\u00famero real.\nValor encontrado: ({2}).";
    private static final String error_attribute_not_enum = "O valor {1} do atributo {0} n\u00e3o \u00e9 do tipo enumera\u00e7\u00e3o.";
    private final String error_above_maximum = "O valor do atributo {1} do elemento {0} est\u00e1 acima do valor m\u00e1ximo permitido.\nValor encontrado: ({2}).\nValor m\u00e1ximo: {3}.\n";
    private final String error_below_minimum = "O valor do atributo {1} do elemento {0} est\u00e1 abaixo do valor m\u00ednimo permitido.\nValor encontrado: ({2}).\nValor m\u00ednimo: {3}.\n";
    private final String error_attribute_not_integer = "O valor do atributo {1} do elemento {0} deveria ser um n\u00famero inteiro.\nValor encontrado: ({2}).";
    public static final String[] FALSE_VALUES = new String[]{"falso", "false", "F", "nao", "n\u00e3o", "no", "N"};
    public static final String[] TRUE_VALUES = new String[]{"verdadeiro", "true", "V", "T", "sim", "yes", "S", "Y"};
    private Element currentElement;
    private Document document;
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private final Map<String, XmlParser> replacements;

    public void checkAttributes() throws ParseException {
        if (this.currentElement == null) {
            String err = "O atributo currentElement est\u00e1 nulo.";
            throw new IllegalStateException("O atributo currentElement est\u00e1 nulo.");
        }
        if (this.currentElement.hasAttributes()) {
            TreeSet<String> attributeValues = new TreeSet<String>();
            NamedNodeMap nameNodeMap = this.currentElement.getAttributes();
            for (int i = 0; i < nameNodeMap.getLength(); ++i) {
                Attr attribute = (Attr)nameNodeMap.item(i);
                attributeValues.add(attribute.getNodeName());
            }
            String nodeName = this.currentElement.getNodeName();
            throw new ParseException("Alguns atributos do elemento {0} n\u00e3o foram processados.\nAtributos:\n{1}", nodeName, attributeValues);
        }
    }

    public void checkChildElements() throws ParseException {
        if (this.currentElement == null) {
            String err = "O atributo currentElement est\u00e1 nulo.";
            throw new IllegalStateException("O atributo currentElement est\u00e1 nulo.");
        }
        TreeSet<String> elementNames = new TreeSet<String>();
        for (Node childNode = this.currentElement.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 1) continue;
            elementNames.add(childNode.getNodeName());
        }
        if (!elementNames.isEmpty()) {
            String nodeName = this.currentElement.getNodeName();
            throw new ParseException("Alguns elementos filhos do elemento {0} n\u00e3o foram processados.\nElementos-filhos:\n{1}", nodeName, elementNames);
        }
    }

    private void copyAttributes(Element newElement, Element oldElement) {
        NamedNodeMap attributes = oldElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String attributeName = attribute.getNodeName();
            String attributeValue = attribute.getNodeValue();
            newElement.setAttribute(attributeName, attributeValue);
        }
    }

    private void copyChildElements(Element newElement, Element oldElement) {
        NodeList childNodes = oldElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node oldChildNode = childNodes.item(i);
            if (oldChildNode.getNodeType() != 1) continue;
            Element oldChildElement = (Element)oldChildNode;
            Element newChildElement = this.copyElement(oldChildElement);
            newElement.appendChild(newChildElement);
        }
    }

    private Element copyElement(Element element) {
        String nodeName = element.getNodeName();
        Element newElement = this.createElement(nodeName);
        this.copyAttributes(newElement, element);
        this.copyChildElements(newElement, element);
        return newElement;
    }

    private Element createElement(String elementName) {
        return this.document.createElement(elementName);
    }

    private void createReplacements(Map<String, String> replacementMap) throws ParseException {
        for (String elementName : replacementMap.keySet()) {
            String elementText = replacementMap.get(elementName);
            this.replacements.put(elementName, this.createXmlParser(elementText));
        }
    }

    private XmlParser createXmlParser(String elementText) throws ParseException {
        XmlParser parser = new XmlParser();
        parser.parseDocument(new StringReader(elementText));
        return parser;
    }

    public void ensureElementName(String expectedElementName) throws ParseException {
        if (expectedElementName == null) {
            String err = "O par\u00e2metro expectedElementName est\u00e1 nulo.";
            throw new IllegalArgumentException("O par\u00e2metro expectedElementName est\u00e1 nulo.");
        }
        if (this.currentElement == null) {
            String err = "O atributo currentElement est\u00e1 nulo.";
            throw new IllegalStateException("O atributo currentElement est\u00e1 nulo.");
        }
        String currentElementName = this.currentElement.getNodeName();
        if (!currentElementName.equals(expectedElementName)) {
            throw new ParseException("Foi encontrado o elemento {0}, por\u00e9m era esperado o elemento {1}.", currentElementName, expectedElementName);
        }
    }

    public String extractAttributeValue(String attributeName) throws ParseException {
        String attributeValue = this.getAttributeValue(attributeName);
        this.removeAttribute(attributeName);
        return attributeValue;
    }

    public String extractAttributeValue(String attributeName, String defaultValue) {
        String attributeValue = this.getAttributeValue(attributeName, defaultValue);
        this.removeAttribute(attributeName);
        return attributeValue;
    }

    public boolean extractAttributeValueAsBoolean(String attributeName) throws ParseException {
        boolean value = this.getAttributeValueAsBoolean(attributeName);
        this.removeAttribute(attributeName);
        return value;
    }

    public boolean extractAttributeValueAsBoolean(String attributeName, boolean defaultValue) throws ParseException {
        boolean attributeValue = this.getAttributeValueAsBoolean(attributeName, defaultValue);
        this.removeAttribute(attributeName);
        return attributeValue;
    }

    public Double extractAttributeValueAsDouble(String attributeName, Double defaultValue) throws ParseException {
        Double value = this.getAttributeValueAsDouble(attributeName, defaultValue);
        this.removeAttribute(attributeName);
        return value;
    }

    public Double extractAttributeValueAsDouble(String attributeName, Double defaultValue, Double maximumValue, Double minimumValue) throws ParseException {
        Double value = this.getAttributeValueAsDouble(attributeName, defaultValue, maximumValue, minimumValue);
        this.removeAttribute(attributeName);
        return value;
    }

    public <E extends Enum<E>> E extractAttributeValueAsEnumeration(String attributeName, E defaultValue, StringToEnumConverter<E> converter) throws ParseException {
        E attributeValue = this.getAttributeValueAsEnumeration(attributeName, defaultValue, converter);
        this.removeAttribute(attributeName);
        return attributeValue;
    }

    public <E extends Enum<E>> E extractAttributeValueAsEnumeration(String attributeName, StringToEnumConverter<E> converter) throws ParseException {
        E attributeValue = this.getAttributeValueAsEnumeration(attributeName, converter);
        this.removeAttribute(attributeName);
        return attributeValue;
    }

    public Integer extractAttributeValueAsInteger(String attributeName, Integer defaultValue) throws ParseException {
        Integer value = this.getAttributeValueAsInteger(attributeName, defaultValue);
        this.removeAttribute(attributeName);
        return value;
    }

    public Integer extractAttributeValueAsInteger(String attributeName, Integer maximum, Integer minimum) throws ParseException {
        Integer value = this.getAttributeValueAsInteger(attributeName, maximum, minimum);
        this.removeAttribute(attributeName);
        return value;
    }

    public Integer extractAttributeValueAsInteger(String attributeName, Integer defaultValue, Integer maximumValue, Integer minimumValue) throws ParseException {
        Integer value = this.getAttributeValueAsInteger(attributeName, defaultValue, maximumValue, minimumValue);
        this.removeAttribute(attributeName);
        return value;
    }

    public int getAttributeCount() {
        NamedNodeMap attributes = this.currentElement.getAttributes();
        return attributes.getLength();
    }

    public String getAttributeValue(String attributeName) throws ParseException {
        if (attributeName == null) {
            String err = "O par\u00e2metro attributeName est\u00e1 nulo.";
            throw new IllegalArgumentException("O par\u00e2metro attributeName est\u00e1 nulo.");
        }
        if (this.currentElement == null) {
            String err = "O atributo currentElement est\u00e1 nulo.";
            throw new IllegalStateException("O atributo currentElement est\u00e1 nulo.");
        }
        String attributeValue = this.getAttributeValue(attributeName, null);
        if (attributeValue == null) {
            String nodeName = this.currentElement.getNodeName();
            throw new ParseException("O atributo {1} do elemento {0} n\u00e3o foi encontrado.", nodeName, attributeName);
        }
        return attributeValue;
    }

    public String getAttributeValue(String attributeName, String defaultValue) {
        if (this.currentElement == null) {
            String err = "O atributo currentElement est\u00e1 nulo.";
            throw new IllegalStateException("O atributo currentElement est\u00e1 nulo.");
        }
        Attr attribute = this.currentElement.getAttributeNode(attributeName);
        if (attribute == null) {
            return defaultValue;
        }
        return attribute.getNodeValue();
    }

    public boolean getAttributeValueAsBoolean(String attributeName) throws ParseException {
        String attributeValue = this.getAttributeValue(attributeName);
        for (String trueValue : TRUE_VALUES) {
            if (!trueValue.equalsIgnoreCase(attributeValue)) continue;
            return true;
        }
        for (String falseValue : FALSE_VALUES) {
            if (!falseValue.equalsIgnoreCase(attributeValue)) continue;
            return false;
        }
        throw new ParseException("O valor {1} do atributo {0} n\u00e3o \u00e9 do tipo booleano.", attributeName, attributeValue);
    }

    public boolean getAttributeValueAsBoolean(String attributeName, boolean defaultValue) throws ParseException {
        String attributeValue = this.getAttributeValue(attributeName, Boolean.toString(defaultValue));
        if (attributeValue == null) {
            return defaultValue;
        }
        for (String trueValue : TRUE_VALUES) {
            if (!trueValue.equalsIgnoreCase(attributeValue)) continue;
            return true;
        }
        for (String falseValue : FALSE_VALUES) {
            if (!falseValue.equalsIgnoreCase(attributeValue)) continue;
            return false;
        }
        throw new ParseException("O valor {1} do atributo {0} n\u00e3o \u00e9 do tipo booleano.", attributeName, attributeValue);
    }

    public Double getAttributeValueAsDouble(String attributeName) throws ParseException {
        Double doubleValue = this.getAttributeValueAsDouble(attributeName, null);
        if (doubleValue == null) {
            String nodeName = this.currentElement.getNodeName();
            throw new ParseException("O atributo {1} do elemento {0} n\u00e3o foi encontrado.", nodeName, attributeName);
        }
        return doubleValue;
    }

    public Double getAttributeValueAsDouble(String attributeName, Double defaultValue) throws ParseException {
        Double doubleValue;
        String textValue = defaultValue == null ? null : defaultValue.toString();
        String attributeValue = this.getAttributeValue(attributeName, textValue);
        if (attributeValue == null) {
            return null;
        }
        try {
            doubleValue = new Double(attributeValue);
        }
        catch (NumberFormatException e) {
            String nodeName = this.currentElement.getNodeName();
            throw new ParseException(e, "O valor do atributo {1} do elemento {0} deveria ser um n\u00famero real.\nValor encontrado: ({2}).", nodeName, attributeName, attributeValue);
        }
        return doubleValue;
    }

    public Double getAttributeValueAsDouble(String attributeName, Double maximumValue, Double minimumValue) throws ParseException {
        Double value = this.getAttributeValueAsDouble(attributeName, null, maximumValue, minimumValue);
        if (value == null) {
            String nodeName = this.currentElement.getNodeName();
            throw new ParseException("O atributo {1} do elemento {0} n\u00e3o foi encontrado.", nodeName, attributeName);
        }
        return value;
    }

    public Double getAttributeValueAsDouble(String attributeName, Double defaultValue, Double maximumValue, Double minimumValue) throws ParseException {
        Double doubleValue = this.getAttributeValueAsDouble(attributeName, defaultValue);
        if (doubleValue == null) {
            return null;
        }
        if (maximumValue != null && doubleValue > maximumValue) {
            String nodeName = this.currentElement.getNodeName();
            throw new ParseException("O valor do atributo {1} do elemento {0} est\u00e1 acima do valor m\u00e1ximo permitido.\nValor encontrado: ({2}).\nValor m\u00e1ximo: {3}.\n", nodeName, attributeName, doubleValue, maximumValue);
        }
        if (minimumValue != null && doubleValue < minimumValue) {
            String nodeName = this.currentElement.getNodeName();
            throw new ParseException("O valor do atributo {1} do elemento {0} est\u00e1 abaixo do valor m\u00ednimo permitido.\nValor encontrado: ({2}).\nValor m\u00ednimo: {3}.\n", nodeName, attributeName, doubleValue, minimumValue);
        }
        return doubleValue;
    }

    public <E extends Enum<E>> E getAttributeValueAsEnumeration(String attributeName, E defaultValue, StringToEnumConverter<E> converter) throws ParseException {
        String textValue = defaultValue == null ? null : defaultValue.toString();
        String attributeValue = this.getAttributeValue(attributeName, textValue);
        if (attributeValue == null) {
            return defaultValue;
        }
        E enumValue = converter.valueOf(attributeValue);
        if (enumValue != null) {
            return enumValue;
        }
        throw new ParseException(error_attribute_not_enum, attributeName, attributeValue);
    }

    public <E extends Enum<E>> E getAttributeValueAsEnumeration(String attributeName, StringToEnumConverter<E> converter) throws ParseException {
        String attributeValue = this.getAttributeValue(attributeName);
        E enumValue = converter.valueOf(attributeValue);
        if (enumValue != null) {
            return enumValue;
        }
        throw new ParseException(error_attribute_not_enum, attributeName, attributeValue);
    }

    public Integer getAttributeValueAsInteger(String attributeName) throws ParseException {
        Integer integerValue = this.getAttributeValueAsInteger(attributeName, null);
        if (integerValue == null) {
            String nodeName = this.currentElement.getNodeName();
            throw new ParseException("O atributo {1} do elemento {0} n\u00e3o foi encontrado.", nodeName, attributeName);
        }
        return integerValue;
    }

    public Integer getAttributeValueAsInteger(String attributeName, Integer defaultValue) throws ParseException {
        Integer integerValue;
        String textValue = defaultValue == null ? null : defaultValue.toString();
        String attributeValue = this.getAttributeValue(attributeName, textValue);
        if (attributeValue == null) {
            return null;
        }
        try {
            integerValue = new Integer(attributeValue);
        }
        catch (NumberFormatException e) {
            String nodeName = this.currentElement.getNodeName();
            throw new ParseException(e, "O valor do atributo {1} do elemento {0} deveria ser um n\u00famero inteiro.\nValor encontrado: ({2}).", nodeName, attributeName, attributeValue);
        }
        return integerValue;
    }

    public Integer getAttributeValueAsInteger(String attributeName, Integer maximumValue, Integer minimumValue) throws ParseException {
        Integer value = this.getAttributeValueAsInteger(attributeName, null, maximumValue, minimumValue);
        if (value == null) {
            String nodeName = this.currentElement.getNodeName();
            throw new ParseException("O atributo {1} do elemento {0} n\u00e3o foi encontrado.", nodeName, attributeName);
        }
        return value;
    }

    public Integer getAttributeValueAsInteger(String attributeName, Integer defaultValue, Integer maximumValue, Integer minimumValue) throws ParseException {
        Integer integerValue = this.getAttributeValueAsInteger(attributeName, defaultValue);
        if (integerValue == null) {
            return null;
        }
        if (maximumValue != null && integerValue > maximumValue) {
            String nodeName = this.currentElement.getNodeName();
            throw new ParseException("O valor do atributo {1} do elemento {0} est\u00e1 acima do valor m\u00e1ximo permitido.\nValor encontrado: ({2}).\nValor m\u00e1ximo: {3}.\n", nodeName, attributeName, integerValue, maximumValue);
        }
        if (minimumValue != null && integerValue < minimumValue) {
            String nodeName = this.currentElement.getNodeName();
            throw new ParseException("O valor do atributo {1} do elemento {0} est\u00e1 abaixo do valor m\u00ednimo permitido.\nValor encontrado: ({2}).\nValor m\u00ednimo: {3}.\n", nodeName, attributeName, integerValue, minimumValue);
        }
        return integerValue;
    }

    public String getElementName() {
        if (this.currentElement == null) {
            String err = "O atributo currentElement est\u00e1 nulo.";
            throw new IllegalStateException("O atributo currentElement est\u00e1 nulo.");
        }
        return this.currentElement.getNodeName();
    }

    public String getElementValue(String defaultValue) {
        if (this.currentElement == null) {
            String err = "O atributo currentElement est\u00e1 nulo.";
            throw new IllegalStateException("O atributo currentElement est\u00e1 nulo.");
        }
        String content = "";
        NodeList childNodes = this.currentElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 3) continue;
            content = content + child.getNodeValue().trim();
        }
        if ((content = content.trim()).length() == 0) {
            return defaultValue;
        }
        return content;
    }

    public boolean goToFirstChild() {
        if (this.currentElement == null) {
            String err = "O atributo currentElement est\u00e1 nulo.";
            throw new IllegalStateException("O atributo currentElement est\u00e1 nulo.");
        }
        NodeList childNodes = this.currentElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            this.currentElement = (Element)childNode;
            return true;
        }
        return false;
    }

    public boolean goToFirstChild(String elementName) {
        if (elementName == null) {
            String err = "O par\u00e2metro elementName est\u00e1 nulo.";
            throw new IllegalArgumentException("O par\u00e2metro elementName est\u00e1 nulo.");
        }
        if (this.currentElement == null) {
            String err = "O atributo currentElement est\u00e1 nulo.";
            throw new IllegalStateException("O atributo currentElement est\u00e1 nulo.");
        }
        NodeList childNodes = this.currentElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !elementName.equals(childNode.getNodeName())) continue;
            this.currentElement = (Element)childNode;
            return true;
        }
        return false;
    }

    public boolean goToNextSibling() {
        if (this.currentElement == null) {
            String err = "O atributo currentElement est\u00e1 nulo.";
            throw new IllegalStateException("O atributo currentElement est\u00e1 nulo.");
        }
        for (Node nextSibling = this.currentElement.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (nextSibling.getNodeType() != 1) continue;
            this.currentElement = (Element)nextSibling;
            return true;
        }
        return false;
    }

    public boolean goToNextSibling(String elementName) {
        if (elementName == null) {
            String err = "O par\u00e2metro elementName est\u00e1 nulo.";
            throw new IllegalArgumentException("O par\u00e2metro elementName est\u00e1 nulo.");
        }
        if (this.currentElement == null) {
            String err = "O atributo currentElement est\u00e1 nulo.";
            throw new IllegalStateException("O atributo currentElement est\u00e1 nulo.");
        }
        for (Node siblingNode = this.currentElement.getNextSibling(); siblingNode != null; siblingNode = siblingNode.getNextSibling()) {
            if (siblingNode.getNodeType() != 1 || !elementName.equals(siblingNode.getNodeName())) continue;
            this.currentElement = (Element)siblingNode;
            return true;
        }
        return false;
    }

    public boolean goToParent() {
        if (this.currentElement == null) {
            String err = "O atributo currentElement est\u00e1 nulo.";
            throw new IllegalStateException("O atributo currentElement est\u00e1 nulo.");
        }
        Node parentNode = this.currentElement.getParentNode();
        if (parentNode == null) {
            return false;
        }
        if (parentNode.getNodeType() != 1) {
            return false;
        }
        this.currentElement = (Element)parentNode;
        return true;
    }

    public void goToRoot() {
        if (this.document == null) {
            String err = "O atributo document est\u00e1 nulo.";
            throw new IllegalStateException("O atributo document est\u00e1 nulo.");
        }
        this.currentElement = this.document.getDocumentElement();
    }

    public boolean hasAttributeValue(String attributeName) {
        String value = this.getAttributeValue(attributeName, null);
        return value != null;
    }

    private void moveChildElements(Element newElement, Element oldElement) {
        NodeList children = oldElement.getChildNodes();
        while (children.getLength() != 0) {
            Node childNode = children.item(0);
            oldElement.removeChild(childNode);
            newElement.appendChild(childNode);
        }
    }

    public void parseDocument(Reader reader) throws ParseException {
        if (reader == null) {
            String err = "O par\u00e2metro reader est\u00e1 nulo.";
            throw new IllegalArgumentException("O par\u00e2metro reader est\u00e1 nulo.");
        }
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            this.document = builder.parse(new InputSource(reader));
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e, "Erro nas configura\u00e7\u00f5es do parser.", new Object[0]);
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex == null) {
                ex = e;
            }
            throw new ParseException(e, "Erro de sintaxe no arquivo.\nDetalhes: {0}.", ex.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new ParseException(e, "Erro de IO ao ler o arquivo.", new Object[0]);
        }
        while (this.replaceElements()) {
        }
    }

    private void removeAttribute(String attributeName) {
        this.currentElement.removeAttribute(attributeName);
    }

    private boolean replaceCurrentElement() {
        boolean wasReplaced = false;
        XmlParser parser = this.replacements.get(this.getElementName());
        if (parser != null) {
            parser.goToRoot();
            Element newElement = this.createElement(parser.currentElement.getNodeName());
            this.copyAttributes(newElement, parser.currentElement);
            this.moveChildElements(newElement, this.currentElement);
            this.copyChildElements(newElement, parser.currentElement);
            this.copyAttributes(newElement, this.currentElement);
            this.replaceElement(newElement, this.currentElement);
            this.currentElement = newElement;
            wasReplaced = true;
        }
        if (this.goToFirstChild()) {
            if (this.replaceCurrentElement()) {
                wasReplaced = true;
            }
            this.goToParent();
        }
        if (this.goToNextSibling() && this.replaceCurrentElement()) {
            wasReplaced = true;
        }
        return wasReplaced;
    }

    private void replaceElement(Element newElement, Element oldElement) {
        Node parentNode = oldElement.getParentNode();
        parentNode.replaceChild(newElement, oldElement);
    }

    private boolean replaceElements() {
        this.goToRoot();
        boolean wasReplaced = this.replaceCurrentElement();
        this.currentElement = null;
        return wasReplaced;
    }

    XmlParser() {
        this.factory.setCoalescing(true);
        this.factory.setIgnoringComments(true);
        this.factory.setIgnoringElementContentWhitespace(true);
        this.factory.setExpandEntityReferences(false);
        this.replacements = new HashMap<String, XmlParser>();
    }

    public XmlParser(Map<String, String> replacements) throws ParseException {
        this();
        this.createReplacements(replacements);
    }
}

