/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.console.AbstractConsoleApp;
import csbase.console.AdminParams;
import csbase.console.BasicParams;
import csbase.exception.CSBaseException;
import csbase.exception.PermissionException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.CommonProjectInfo;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;
import csbase.logic.User;
import csbase.logic.UserOutline;
import csbase.logic.UserProjectInfo;
import csbase.logic.diagnosticservice.PropertyInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ServerServiceInterface;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import tecgraf.javautils.core.io.FileUtils;

public class Admin
extends AbstractConsoleApp {
    private static final String REMOTE_ENCODING = "ISO-8859-1";
    boolean serverHasBeenShutdown = false;
    static final int ADMIN_AUTHENTICATION_ERROR_CODE = 3;

    Admin(String[] args) {
        super(args);
    }

    @Override
    protected BasicParams createParams() {
        return new AdminParams();
    }

    @Override
    protected void processExtraParams() {
    }

    @Override
    public String getLogin() {
        AdminParams params = (AdminParams)this.getParams();
        String login = (String)(params.userLogin == null ? User.getAdminId() : params.userLogin);
        return login;
    }

    private void execute() throws IOException {
        AdminParams params = (AdminParams)this.getParams();
        try {
            if (params.version) {
                this.showSystemVersion();
            } else if (params.listLoggedUsers) {
                this.listLoggedUsers();
            } else if (params.shutdown) {
                this.shutdownServer();
            } else if (params.listSGAs) {
                this.listSGAs();
            } else if (params.stopAllSGAs) {
                this.stopAllSGAs();
            } else if (params.restartAllSGAs) {
                this.restartAllSGAs();
            } else if (params.sgaToStop != null) {
                this.stopSGA(params.sgaToStop);
            } else if (params.sgaToRestart != null) {
                this.restartSGA(params.sgaToRestart);
            } else if (params.sgaToGetInfo != null) {
                this.showInfoFromSGA(params.sgaToGetInfo);
            } else if (params.cmdIdToKill != null) {
                this.killSGAcmd(params.cmdIdToKill);
            } else if (params.blockCmdQueue != null) {
                this.blockCmdsQueue(params.blockCmdQueue);
            } else if (params.listProps) {
                this.listProperties();
            } else if (params.msgToAll != null) {
                this.sendMsgToAll();
            } else if (params.msgToLogged != null) {
                this.sendMsgToLogged();
            } else if (params.msgToUser != null) {
                this.sendMsgToUser(params.msgRecipient);
            } else if (params.remoteSrcPath != null) {
                this.copyRemoteFile(params.remoteSrcPath, params.localDestDir);
            } else if (params.localSrcPath != null) {
                if (params.remoteDestDir == null) {
                    this.printError("diret\u00f3rio remoto n\u00e3o foi especificado", new Object[0]);
                }
                this.copyLocalFile(params.localSrcPath, params.remoteDestDir);
            } else if (params.dirToCreate != null) {
                this.createDir(params.dirToCreate);
            } else if (params.fileToremove != null) {
                this.removeRemote(params.fileToremove, params.force);
            } else if (params.prjToCreate != null) {
                this.createProject(params.prjToCreate);
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                this.printStackTrace(e);
            }
            this.printError(msg, new Object[0]);
        }
    }

    private void createDir(String dirPath) throws RemoteException {
        String[] fullPath = FileUtils.splitPath((String)dirPath, (char)'/');
        if (fullPath.length == 1) {
            this.printError("n\u00e3o foi especificado um diret\u00f3rio", new Object[0]);
            return;
        }
        CommonClientProject project = this.openProject(fullPath[0]);
        if (project == null) {
            return;
        }
        String[] dirPathArray = Arrays.copyOfRange(fullPath, 1, fullPath.length);
        ClientRemoteLocator.projectService.createDirectory(project.getId(), dirPathArray);
    }

    private void createProject(String prjSpec) throws Exception {
        User user = this.getUser(prjSpec);
        if (user == null) {
            return;
        }
        String projectName = Admin.getProjectName(prjSpec);
        CommonProjectInfo projectInfo = new CommonProjectInfo();
        projectInfo.userId = user.getId();
        projectInfo.name = projectName;
        projectInfo.description = "Projeto criado por " + this.getLogin();
        ClientRemoteLocator.projectService.createProject(projectInfo);
    }

    private void removeRemote(String path, boolean force) throws RemoteException {
        String prompt;
        String[] fullPath = FileUtils.splitPath((String)path, (char)'/');
        if (fullPath.length == 1) {
            this.printError("este comando n\u00e3o remove projetos", new Object[0]);
            return;
        }
        CommonClientProject project = this.openProject(fullPath[0]);
        if (project == null) {
            return;
        }
        String[] pathArray = Arrays.copyOfRange(fullPath, 1, fullPath.length);
        ClientProjectFile file = ClientRemoteLocator.projectService.getChild(project.getId(), pathArray);
        if (!force && !this.confirm(prompt = file.isDirectory() ? "\nATEN\u00c7\u00c3O: a remo\u00e7\u00e3o deste diret\u00f3rio causar\u00e1 erro caso ele esteja sendo\nusado por algum usu\u00e1rio.\n\nConfirma sua remo\u00e7\u00e3o e de todo o seu conte\u00fado?" : "\nATEN\u00c7\u00c3O: a remo\u00e7\u00e3o deste arquivo causar\u00e1 erro caso ele esteja sendo\nusado por algum usu\u00e1rio.\n\nConfirma sua remo\u00e7\u00e3o?", new Object[0])) {
            this.printInfo("opera\u00e7\u00e3o cancelada", new Object[0]);
            return;
        }
        ClientRemoteLocator.projectService.removeFile(project.getId(), pathArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyLocalFile(String localSrcPath, String remoteDirPath) throws IOException {
        File localFile;
        CommonClientProject project;
        String[] fullPath;
        BufferedWriter writer;
        BufferedReader reader;
        block5: {
            block4: {
                reader = null;
                writer = null;
                try {
                    fullPath = FileUtils.splitPath((String)remoteDirPath, (char)'/');
                    project = this.openProject(fullPath[0]);
                    if (project != null) break block4;
                }
                catch (Throwable throwable) {
                    FileUtils.close(reader);
                    FileUtils.close(writer);
                    throw throwable;
                }
                FileUtils.close(reader);
                FileUtils.close(writer);
                return;
            }
            localFile = this.getLocalSrcFile(localSrcPath);
            if (localFile != null) break block5;
            FileUtils.close(reader);
            FileUtils.close(writer);
            return;
        }
        String[] filePath = fullPath.length > 1 ? Arrays.copyOfRange(fullPath, 1, fullPath.length) : new String[]{};
        Object prjId = project.getId();
        ClientProjectFile remoteFile = ClientRemoteLocator.projectService.createAndGetFile(prjId, filePath, localFile.getName(), "UNKNOWN");
        OutputStream outputStream = remoteFile.getOutputStream();
        writer = new BufferedWriter(new OutputStreamWriter(outputStream, REMOTE_ENCODING));
        reader = new BufferedReader(new FileReader(localFile));
        Admin.copyData(reader, writer);
        ClientRemoteLocator.projectService.closeProject(prjId, false);
        FileUtils.close((Closeable)reader);
        FileUtils.close((Closeable)writer);
    }

    private File getLocalSrcFile(String localSrcPath) {
        File localFile = localSrcPath.charAt(0) != '/' ? new File(this.getCurrentDir(), localSrcPath) : new File(localSrcPath);
        if (!localFile.exists()) {
            this.printError(localSrcPath + " n\u00e3o existe", new Object[0]);
            return null;
        }
        if (localFile.isDirectory()) {
            this.printError(localSrcPath + " \u00e9 um diret\u00f3rio", new Object[0]);
            return null;
        }
        return localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyRemoteFile(String remotePath, String localDirPath) throws IOException {
        File localFile;
        ClientProjectFile remoteFile;
        BufferedWriter writer;
        BufferedReader reader;
        block7: {
            String fileName;
            block6: {
                CommonClientProject project;
                String[] filePath;
                block5: {
                    reader = null;
                    writer = null;
                    try {
                        String[] fullPath = FileUtils.splitPath((String)remotePath, (char)'/');
                        filePath = Arrays.copyOfRange(fullPath, 1, fullPath.length - 1);
                        fileName = fullPath[fullPath.length - 1];
                        project = this.openProject(fullPath[0]);
                        if (project != null) break block5;
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(reader);
                        FileUtils.close(writer);
                        throw throwable;
                    }
                    FileUtils.close(reader);
                    FileUtils.close(writer);
                    return;
                }
                remoteFile = ClientRemoteLocator.projectService.getChild(project.getId(), filePath, fileName);
                if (!remoteFile.isDirectory()) break block6;
                this.printError(remotePath + " \u00e9 um diret\u00f3rio", new Object[0]);
                FileUtils.close(reader);
                FileUtils.close(writer);
                return;
            }
            localFile = this.getTargetDir(localDirPath, fileName);
            if (localFile != null) break block7;
            FileUtils.close(reader);
            FileUtils.close(writer);
            return;
        }
        InputStream inputStream = remoteFile.getInputStream();
        reader = new BufferedReader(new InputStreamReader(inputStream, REMOTE_ENCODING));
        writer = new BufferedWriter(new FileWriter(localFile));
        Admin.copyData(reader, writer);
        FileUtils.close((Closeable)reader);
        FileUtils.close((Closeable)writer);
    }

    private CommonClientProject openProject(String prjSpec) {
        try {
            User user = this.getUser(prjSpec);
            if (user == null) {
                return null;
            }
            String projectName = Admin.getProjectName(prjSpec);
            Object prjUserId = user.getId();
            Object loggedUserId = User.getLoggedUser().getId();
            String login = user.getLogin();
            boolean sameUser = loggedUserId.equals(prjUserId);
            List projects = ClientRemoteLocator.projectService.getProjectsSharedWithUser(loggedUserId);
            if (sameUser) {
                projects.addAll(ClientRemoteLocator.projectService.getProjectsFromUser(prjUserId));
            }
            ArrayList<UserProjectInfo> matches = new ArrayList<UserProjectInfo>();
            for (UserProjectInfo prjInfo : projects) {
                if (!projectName.equals(prjInfo.getProjectName())) continue;
                matches.add(prjInfo);
            }
            if (matches.size() == 1) {
                return Admin.openProject((UserProjectInfo)matches.get(0));
            }
            if (matches.isEmpty()) {
                if (sameUser) {
                    this.printError("usu\u00e1rio %s n\u00e3o possui projeto com nome %s", login, projectName);
                } else {
                    this.printError("usu\u00e1rio %s n\u00e1o participa do projeto %s do usu\u00e1rio %s", User.getLoggedUser().getLogin(), projectName, login);
                }
            } else if (Admin.projectSpecIncludesUser(prjSpec)) {
                for (UserProjectInfo prjInfo : matches) {
                    if (!prjUserId.equals(prjInfo.getOwnerId())) continue;
                    return Admin.openProject(prjInfo);
                }
                this.printError("usu\u00e1rio %s n\u00e3o possui projeto com nome %s", login, projectName);
            } else {
                this.printError("o usu\u00e1rio %s possui acesso a mais de um projeto com nome '%s'", login, projectName);
            }
        }
        catch (Exception e) {
            this.printError("usu\u00e1rio e/ou projeto inv\u00e1lidos", new Object[0]);
        }
        return null;
    }

    private static boolean projectSpecIncludesUser(String prjSpec) {
        return prjSpec.indexOf(58) != -1;
    }

    private static CommonClientProject openProject(UserProjectInfo prjInfo) throws RemoteException {
        return ClientRemoteLocator.projectService.openProject(prjInfo.getProjectId(), false);
    }

    private User getUser(String prjSpec) throws Exception {
        int pos = prjSpec.indexOf(58);
        String login = pos != -1 ? prjSpec.substring(0, pos) : this.getLogin();
        User user = User.getUserByLogin((String)login);
        if (user == null) {
            this.printError("usu\u00e1rio inv\u00e1lido: %s", login);
        }
        return user;
    }

    private static String getProjectName(String prjSpec) {
        int pos = prjSpec.indexOf(58);
        if (pos != -1) {
            return prjSpec.substring(pos + 1, prjSpec.length());
        }
        return prjSpec;
    }

    private static void copyData(BufferedReader reader, BufferedWriter writer) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            writer.write(line);
            writer.newLine();
            line = reader.readLine();
        }
    }

    private File getTargetDir(String localDirPath, String fileName) {
        File localFile;
        if (localDirPath != null) {
            File localDir = this.getLocalSrcFile(localDirPath);
            if (!localDir.exists()) {
                this.printError(localDirPath + " n\u00e3o \u00e9 um diret\u00f3rio local v\u00e1lido", new Object[0]);
                return null;
            }
            localFile = new File(localDir, fileName);
        } else {
            localFile = new File(this.getCurrentDir(), fileName);
        }
        if (localFile.exists()) {
            this.printError(localFile.getAbsolutePath() + " j\u00e1 existe", new Object[0]);
            return null;
        }
        return localFile;
    }

    private void showSystemVersion() throws RemoteException {
        this.println(this.getSystemVersion(), new Object[0]);
        if (this.isAdmin(false)) {
            this.println("\n" + this.getDeploymentInfo(), new Object[0]);
        }
    }

    private void sendMsgToAll() throws RemoteException {
        AdminParams params = (AdminParams)this.getParams();
        ClientRemoteLocator.notificationService.notifyTo(null, params.msgToAll, true, false);
    }

    private void sendMsgToLogged() throws RemoteException {
        UserOutline[] loggedUsers = ClientRemoteLocator.server.getLoggedUsers();
        HashSet<Object> ids = new HashSet<Object>();
        for (int i = 0; i < loggedUsers.length; ++i) {
            ids.add(loggedUsers[i].getId());
        }
        AdminParams params = (AdminParams)this.getParams();
        ClientRemoteLocator.notificationService.notifyTo(ids.toArray(), params.msgToLogged, true, true);
    }

    private void sendMsgToUser(String msgRecipient) {
        if (msgRecipient == null) {
            this.printError("destinat\u00e1rio da mensagem n\u00e3o foi fornecido", new Object[0]);
            return;
        }
        try {
            User recipient = User.getUserByLogin((String)msgRecipient);
            if (recipient != null) {
                AdminParams params = (AdminParams)this.getParams();
                ClientRemoteLocator.notificationService.notifyTo(new Object[]{recipient.getId()}, params.msgToUser, true, true);
            } else {
                this.printError("usu\u00e1rio " + msgRecipient + " n\u00e3o existe", new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void listProperties() throws RemoteException {
        if (!this.isAdmin(true)) {
            return;
        }
        ServerServiceInterface serverService = ClientRemoteLocator.serverService;
        if (serverService == null) {
            this.printError("servi\u00e7o 'ServerService' n\u00e3o foi habilitado para este servidor", new Object[0]);
            return;
        }
        String properties = serverService.listRuntimeProperties();
        AdminParams params = (AdminParams)this.getParams();
        if (params.propsPattern == null) {
            this.println(properties, new Object[0]);
        } else {
            Matcher matcher = params.propsPattern.matcher(properties);
            while (matcher.find()) {
                this.println(matcher.group(), new Object[0]);
            }
        }
        this.println("=========", new Object[0]);
        Collection infos = ClientRemoteLocator.diagnosticService.getPropertiesInfo().values();
        for (PropertyInfo info : infos) {
            this.println(info.key + "=" + info.runtimeValue + " (" + info.serviceValue + ", " + info.serverValue + ", " + info.systemValue + ", " + info.commandLineValue + ")", new Object[0]);
        }
    }

    private void blockCmdsQueue(String blockCmdQueue) throws RemoteException {
        if (!this.isAdmin(true)) {
            return;
        }
        ClientRemoteLocator.schedulerService.setBlocked(Boolean.valueOf(blockCmdQueue).booleanValue());
    }

    private void killSGAcmd(String cmdIdToKill) throws RemoteException {
        if (!ClientRemoteLocator.sgaService.killCommand(cmdIdToKill)) {
            this.printError("o comando n\u00e3o foi encerrado", new Object[0]);
            this.printError("cerifique-se de que o comando existe e que voc\u00ea tem permiss\u00e3o para interromp\u00ea-lo", new Object[0]);
        }
    }

    private void showInfoFromSGA(String sgaToGetInfo) throws RemoteException {
        SGAInfo info = this.getSGAInfo(sgaToGetInfo);
        if (info != null) {
            this.println("host                      = " + info.getHostName(), new Object[0]);
            this.println("plataforma                = " + info.getPlatformId(), new Object[0]);
            this.println("ativo                     = " + info.getAlive(), new Object[0]);
            this.println("jobs em execu\u00e7\u00e3o          = " + info.getNumberOfJobs(), new Object[0]);
            this.println("requisitos                = " + info.getRequirements(), new Object[0]);
            this.println("sandbox de execu\u00e7\u00e3o       = " + FileUtils.joinPath((boolean)true, (char)info.getFileSeparator(), (String[])info.getSandboxRootDirectory()), new Object[0]);
            this.println("reposit\u00f3rio de algoritmos = " + FileUtils.joinPath((boolean)true, (char)info.getFileSeparator(), (String[])info.getAlgorithmRootDirectory()), new Object[0]);
            this.println("reposit\u00f3rio de projetos   = " + FileUtils.joinPath((boolean)true, (char)info.getFileSeparator(), (String[])info.getProjectRootDirectory()), new Object[0]);
        } else {
            this.printError("n\u00e3o existe SGA registrado com nome " + sgaToGetInfo, new Object[0]);
        }
    }

    protected SGAInfo getSGAInfo(String sgaToGetInfo) throws RemoteException {
        SGAInfo info = ClientRemoteLocator.sgaService.getInfo(sgaToGetInfo, 0);
        return info;
    }

    private void shutdownServer() throws PermissionException, RemoteException {
        String msg;
        String answer;
        if (!this.isAdmin(true)) {
            return;
        }
        UserOutline[] loggedUsers = Admin.getLoggedUsers();
        AdminParams params = (AdminParams)this.getParams();
        if (loggedUsers.length > 1 && !params.force && !(answer = this.readLine(msg = "Existe(m) %d usu\u00e1rio(s) logado(s). Confirma shutdown do servidor? (s/n) ", loggedUsers.length - 1)).equalsIgnoreCase("s")) {
            System.out.println("opera\u00e7\u00e3o cancelada pelo usu\u00e1rio");
            return;
        }
        try {
            ClientRemoteLocator.killServerService.shutdown();
        }
        catch (UnmarshalException unmarshalException) {
            // empty catch block
        }
        this.serverHasBeenShutdown = true;
    }

    private void restartAllSGAs() throws RemoteException {
        if (!this.isAdmin(true)) {
            return;
        }
        ClientRemoteLocator.sgaService.restartAllSGAs();
    }

    private void stopAllSGAs() throws RemoteException {
        if (!this.isAdmin(true)) {
            return;
        }
        ClientRemoteLocator.sgaService.shutdownAllSGAs();
    }

    private void restartSGA(String sgaToRestart) throws RemoteException {
        if (!this.isAdmin(true)) {
            return;
        }
        ClientRemoteLocator.sgaService.restartSGA(sgaToRestart);
    }

    private void stopSGA(String sgaToStop) throws RemoteException {
        if (!this.isAdmin(true)) {
            return;
        }
        ClientRemoteLocator.sgaService.shutdownSGA(sgaToStop);
    }

    private void listSGAs() throws RemoteException {
        Vector sgaNames = ClientRemoteLocator.sgaService.getAllSGANames();
        if (sgaNames.isEmpty()) {
            this.printInfo("n\u00e3o h\u00e1 nenhum SGA registrado no servidor", new Object[0]);
        } else {
            this.println();
            int maxLen = Admin.getMaxStrLen(sgaNames);
            Collections.sort(sgaNames);
            for (String sga : sgaNames) {
                SGASet sgaSet = ClientRemoteLocator.sgaService.getSGASet(sga);
                String extraInfo = sgaSet.isCluster() ? Admin.getClusterInfo(sgaSet) : (sgaSet.getAlive() ? "dispon\u00edvel" : "indispon\u00edvel");
                String fmt = "%-" + (maxLen + 3) + "s%s";
                this.println(fmt, sga, extraInfo);
            }
        }
        boolean blocked = ClientRemoteLocator.schedulerService.isBlocked();
        if (blocked) {
            this.println();
            this.printInfo("a fila de comandos est\u00e1 bloqueada", new Object[0]);
        }
    }

    private static String getClusterInfo(SGASet sga) throws RemoteException {
        SGAInfo[] infos = ClientRemoteLocator.sgaService.getAllInfo(sga.getName());
        int numInactive = 0;
        for (SGAInfo info : infos) {
            if (info.getAlive()) continue;
            ++numInactive;
        }
        if (numInactive > 0) {
            return String.format("cluster (%d n\u00f3s, %d indispon\u00edveis)", infos.length, numInactive);
        }
        return String.format("cluster %d n\u00f3s dispon\u00edveis)", infos.length);
    }

    private void listLoggedUsers() throws RemoteException {
        UserOutline[] loggedUsers;
        for (UserOutline userOutline : loggedUsers = Admin.getLoggedUsers()) {
            this.println("%-10s%s", userOutline.getLogin(), userOutline.getName());
        }
    }

    static UserOutline[] getLoggedUsers() throws RemoteException {
        UserOutline[] loggedUsers = ClientRemoteLocator.server.getLoggedUsers();
        Arrays.sort(loggedUsers, new Comparator<UserOutline>(){

            @Override
            public int compare(UserOutline o1, UserOutline o2) {
                return o1.getLogin().compareTo(o2.getLogin());
            }
        });
        return loggedUsers;
    }

    public static void main(String[] args) throws CSBaseException, IOException {
        Admin client = new Admin(args);
        if (client.login()) {
            client.execute();
            client.logout();
        } else {
            System.exit(3);
        }
    }

    @Override
    protected boolean preLogout() {
        return !this.serverHasBeenShutdown;
    }
}

