/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.client.Client;
import csbase.client.ClientUI;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationManagerListener;
import csbase.client.desktop.DesktopFrame;
import csbase.client.kernel.ClientException;
import csbase.client.login.InitialContext;
import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.User;
import java.awt.Window;
import java.text.MessageFormat;
import javax.swing.JFrame;
import tecgraf.javautils.core.lng.LNG;

public class VisualAdminUI
implements ClientUI {
    DesktopFrame mainFrame;

    public void preInitialization(InitialContext initialContext) throws ClientException {
        this.mainFrame = new DesktopFrame();
    }

    public void showUI() {
        try {
            if (!User.getLoggedUser().isAdmin()) {
                String err = MessageFormat.format(LNG.get((String)"VisualAdminUI.message.user.not.admin"), User.getLoggedUser().getName());
                StandardErrorDialogs.showErrorDialog((Window)this.getView(), (Object)err);
                Client.getInstance().shutdown();
            } else {
                ApplicationManager.getInstance().addListener(new ApplicationManagerListener(){

                    public void applicationEnded(String id) {
                        if (id.equals("serverdiagnostic")) {
                            VisualAdminUI.this.exitClient();
                        }
                    }

                    public void applicationStarted(String id) {
                    }
                });
                ApplicationManager.getInstance().runApplication("serverdiagnostic");
            }
        }
        catch (ApplicationException e) {
            Client.getInstance().shutdown();
        }
    }

    public void postInitialization() {
    }

    public JFrame getView() {
        return this.mainFrame.getDesktopFrame();
    }

    public void exitClient() {
        ApplicationManager.getInstance().finishAllApplications();
        MessageProxy.clearListeners();
        Client.getInstance().shutdown();
    }
}

