/**
 * $Id$
 */
package csbase.console.remote;

import java.rmi.RemoteException;
import java.util.Locale;

import csbase.console.Admin;
import csbase.exception.CSBaseException;
import csbase.logic.ServerURI;
import csbase.logic.Session;
import csbase.logic.SingleServerManager;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.UserPasswordAuthenticator;

/**
 * Monitor da comunicao com o servidor feita pelo {@link Admin cliente
 * executado do console}.
 * 
 * @author Tecgraf
 */
public class ClientRemoteMonitor extends SingleServerManager {

  private final static int WINDOWS_SIZE = 10;

  /**
   * Autenticador de usurio/senha.
   */
  private UserPasswordAuthenticator authenticator;

  /**
   * Construtor.
   * 
   * @param server endereo do servidor (sem protocolo nem porta)
   * @param port porta para conexo com o servidor
   * @param login login do usurio
   * @param password senha
   * @param verbose <code>true</code> se mensagens informativas devem ser
   *        exibidas, <code>false</code> para exibir apenas mensagens de erro ou
   *        alertas
   */
  public ClientRemoteMonitor(String server, int port, String login,
    String password, boolean verbose) {
    super(ServerURI.create(server, port), ClientRemoteLocator.class, verbose,
      WINDOWS_SIZE);
    authenticator = new UserPasswordAuthenticator(login, password, Locale
      .getDefault());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected String lang(String key) {
    return key;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Session login() throws CSBaseException, RemoteException {
    Session session;
    session = authenticator.authenticate(this.getServer());
    if (session == null) {
      return null;
    }

    User user = session.getUser();
    User.registerLogin(session.getKey(), user);
    return session;
  }

}
