/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.console.AbstractConsoleApp;
import csbase.console.BasicParams;
import csbase.console.CheckBundlesParams;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckBundlesApp
extends AbstractConsoleApp {
    static final int ADMIN_AUTHENTICATION_ERROR_CODE = 3;
    private final String DEFAULT_METHOD_TO_FIND = "getString";
    private Map<ApplicationRegistry, BundleValidation> validation = new HashMap<ApplicationRegistry, BundleValidation>();

    CheckBundlesApp(String[] args) {
        super(args);
    }

    @Override
    protected BasicParams createParams() {
        return new CheckBundlesParams();
    }

    @Override
    public String getLogin() {
        CheckBundlesParams params = (CheckBundlesParams)this.getParams();
        String login = (String)(params.userLogin == null ? User.getAdminId() : params.userLogin);
        return login;
    }

    public static void main(String[] args) throws IOException {
        CheckBundlesApp client = new CheckBundlesApp(args);
        if (client.login()) {
            client.execute();
            client.logout();
        } else {
            System.exit(3);
        }
    }

    private void execute() {
        CheckBundlesParams params = (CheckBundlesParams)this.getParams();
        try {
            if (params.english) {
                ApplicationManager.setInstance((Locale)new Locale("en", "US"));
            } else {
                ApplicationManager.setInstance((Locale)new Locale("pt", "BR"));
            }
            if (params.appToCheck != null) {
                this.checkApplicationsBundle(params.appToCheck);
            } else if (params.checkAllApps) {
                this.checkAllApplicationsBundles();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkAllApplicationsBundles() throws Exception {
        ArrayList regs = ApplicationManager.getInstance().getAllApplicationRegistries();
        for (ApplicationRegistry reg : regs) {
            this.checkApplicationsBundle(reg);
        }
    }

    private void checkApplicationsBundle(String id) throws Exception {
        ApplicationRegistry reg = ApplicationManager.getInstance().getApplicationRegistry(id);
        this.checkApplicationsBundle(reg);
    }

    private void checkApplicationsBundle(ApplicationRegistry reg) throws Exception {
        this.validation.put(reg, new BundleValidation());
        Class<?> appClass = Class.forName(reg.getClassName());
        String classSourceName = appClass.getSimpleName() + ".java";
        URL baseUrl = appClass.getResource(".");
        URL classURL = null;
        classURL = baseUrl != null ? new URL(baseUrl, classSourceName) : appClass.getResource(classSourceName);
        if (classURL == null) {
            System.out.println("Arquivo " + classSourceName + " n\u00e3o encontrado.");
            return;
        }
        if (!"file".equalsIgnoreCase(classURL.getProtocol())) {
            throw new IllegalStateException("Classe n\u00e3o est\u00e1 em um arquivo.");
        }
        File path = new File(classURL.getPath());
        this.scanFilesForApp(reg, path.getParentFile());
    }

    private void scanFilesForApp(ApplicationRegistry reg, File root) throws Exception {
        this.scanFiles(reg, root);
        this.printResult(reg);
    }

    private void printResult(ApplicationRegistry reg) {
        System.out.println("------- CHAVES N\u00c3O ENCONTRADAS NOS BUNDLES DA APP " + reg.getId() + " -------");
        BundleValidation appValidation = this.validation.get(reg);
        for (String fileName : appValidation.keysNotDefinedInBundles.keySet()) {
            System.out.println(">>> Arquivo: " + fileName);
            Set keysNotDefined = (Set)appValidation.keysNotDefinedInBundles.get(fileName);
            for (String key : keysNotDefined) {
                System.out.println(key);
            }
        }
        CheckBundlesParams params = (CheckBundlesParams)this.getParams();
        if (params.showUnreferencedKeys) {
            Set appKeys = reg.getResourceBundle().allKeys();
            appKeys.removeAll(this.validation.get(reg).keysDefinedInBundles);
            if (appKeys != null && !appKeys.isEmpty()) {
                System.out.println("------- CHAVES N\u00c3O USADAS NA APP " + reg.getId() + " -------");
                for (String key : appKeys) {
                    System.out.println(key);
                }
            }
        }
    }

    private void scanFiles(ApplicationRegistry reg, File root) throws Exception {
        File[] list = root.listFiles();
        if (list == null) {
            return;
        }
        for (File f : list) {
            if (f.isDirectory()) {
                this.scanFiles(reg, new File(f.getAbsolutePath()));
                continue;
            }
            this.searchPattern(reg, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchPattern(ApplicationRegistry reg, File file) throws Exception {
        if (file.getName().endsWith(".svn-base")) {
            return;
        }
        try (BufferedReader r = null;){
            String line;
            Pattern pattStaticKey = Pattern.compile("getString\\s*\\(\\s*\"(.*?)\"\\s*[,|\\)]");
            r = new BufferedReader(new FileReader(file));
            while ((line = r.readLine()) != null) {
                Matcher m = pattStaticKey.matcher(line);
                while (m.find()) {
                    int count = m.groupCount();
                    for (int i = 1; i <= count; ++i) {
                        String key = m.group(i);
                        if (reg.hasString(key)) {
                            this.validation.get(reg).addKeyDefined(key);
                            continue;
                        }
                        this.validation.get(reg).addKeyNotDefined(file.getName(), key);
                    }
                }
            }
        }
    }

    private static class BundleValidation {
        private Map<String, Set<String>> keysNotDefinedInBundles = new HashMap<String, Set<String>>();
        private Set<String> keysDefinedInBundles = new TreeSet<String>();

        BundleValidation() {
        }

        public void addKeyNotDefined(String fileName, String key) {
            if (this.keysNotDefinedInBundles.get(fileName) == null) {
                this.keysNotDefinedInBundles.put(fileName, new TreeSet());
            }
            this.keysNotDefinedInBundles.get(fileName).add(key);
        }

        public void addKeyDefined(String key) {
            this.keysDefinedInBundles.add(key);
        }
    }
}

