package csbase.console;

import org.kohsuke.args4j.Option;

/**
 * Parmetros comuns aos clientes console.
 *
 * @author Tecgraf
 */
class BasicParams {

  /**
   * Exibe texto de ajuda.
   */
  @Option(name = "--help", aliases = "-h", usage = "exibe este texto de ajuda")
  protected boolean showHelp;
  /**
   * URI do servidor.
   */
  @Option(name = "--server", aliases = "-s", required = true, usage = "URI do servidor", metaVar = "servidor")
  protected String serverURI = null;
  /**
   * Porta para conexo com o servidor.
   */
  @Option(name = "--port", aliases = "-p", required = true, usage = "porta para conexo com o servidor", metaVar = "porta")
  protected int port;

  /**
   * Grava a sada em um arquivo (mensagens de erro sero exibidas tambm em
   * {@link System#err}).
   */
  @Option(name = "--output", aliases = "-o", usage = "grava a sada em um arquivo", metaVar = "arq")
  protected String outputFile;

}
