/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.model;

import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.model.ResourceType;
import br.com.petrobras.security.model.i18n.I18nString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class Resource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long uid;
    private String id;
    private I18nString nameTranslations = new I18nString();
    private I18nString descriptionTranslations = new I18nString();
    private I18nString commentTranslations = new I18nString();
    private boolean statisticsEnabled;
    private Date creationDate;
    private Resource parent;
    private ApplicationEnvironment applicationEnvironment;
    private List<Resource> children = new ArrayList<Resource>();
    private ResourceType type;

    public Resource() {
    }

    public Resource(String id) {
        this.id = id;
    }

    public Resource(String id, boolean statisticsEnabled, ResourceType type) {
        this.id = id;
        this.statisticsEnabled = statisticsEnabled;
        this.type = type;
    }

    public Resource(String id, String name, String description, String comment, ResourceType type) {
        this.id = id;
        this.setName(name);
        this.setDescription(description);
        this.setComment(comment);
        this.type = type;
    }

    public Resource(String id, boolean statisticsEnabled, I18nString nameTranslations, I18nString descriptionTranslations, I18nString commentTranslations, ResourceType type) {
        this.id = id;
        this.statisticsEnabled = statisticsEnabled;
        this.nameTranslations = nameTranslations;
        this.descriptionTranslations = descriptionTranslations;
        this.commentTranslations = commentTranslations;
        this.type = type;
    }

    public Resource(String id, boolean statisticsEnabled, I18nString nameTranslations, I18nString descriptionTranslations, I18nString commentTranslations, Resource parent, List<Resource> children, ResourceType type) {
        this.id = id;
        this.statisticsEnabled = statisticsEnabled;
        this.nameTranslations = nameTranslations;
        this.descriptionTranslations = descriptionTranslations;
        this.commentTranslations = commentTranslations;
        this.parent = parent;
        this.children = children;
        this.type = type;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public Date getCreationDate() {
        if (this.creationDate != null) {
            return (Date)this.creationDate.clone();
        }
        return null;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = (Date)creationDate.clone();
    }

    public ApplicationEnvironment getApplicationEnvironment() {
        return this.applicationEnvironment;
    }

    public void setApplicationEnvironment(ApplicationEnvironment applicationEnvironment) {
        this.applicationEnvironment = applicationEnvironment;
    }

    public Resource getParent() {
        return this.parent;
    }

    public void setParent(Resource parent) {
        this.parent = parent;
    }

    public List<Resource> getChildren() {
        return this.children;
    }

    public void setChildren(List<Resource> children) {
        this.children = children;
    }

    public ResourceType getType() {
        return this.type;
    }

    public void setType(ResourceType type) {
        this.type = type;
    }

    public I18nString getNameTranslations() {
        return this.nameTranslations;
    }

    public void setNameTranslations(I18nString nameTranslations) {
        this.nameTranslations = nameTranslations;
    }

    public I18nString getDescriptionTranslations() {
        return this.descriptionTranslations;
    }

    public void setDescriptionTranslations(I18nString descriptionTranslations) {
        this.descriptionTranslations = descriptionTranslations;
    }

    public I18nString getCommentTranslations() {
        return this.commentTranslations;
    }

    public void setCommentTranslations(I18nString commentTranslations) {
        this.commentTranslations = commentTranslations;
    }

    public String getName(Locale locale) {
        return this.nameTranslations.get(locale);
    }

    public void setName(Locale locale, String nameTranslation) {
        this.nameTranslations.set(locale, nameTranslation);
    }

    public String getDescription(Locale locale) {
        return this.descriptionTranslations.get(locale);
    }

    public void setDescription(Locale locale, String descriptionTranslation) {
        this.descriptionTranslations.set(locale, descriptionTranslation);
    }

    public String getComment(Locale locale) {
        return this.commentTranslations.get(locale);
    }

    public void setComment(Locale locale, String commentTranslation) {
        this.commentTranslations.set(locale, commentTranslation);
    }

    public String getName() {
        return this.nameTranslations.get();
    }

    public void setName(String name) {
        this.nameTranslations.set(name);
    }

    public String getComment() {
        return this.commentTranslations.get();
    }

    public void setComment(String comment) {
        this.commentTranslations.set(comment);
    }

    public String getDescription() {
        return this.descriptionTranslations.get();
    }

    public void setDescription(String description) {
        this.descriptionTranslations.set(description);
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.uid != null ? this.uid.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.uid != null && other.uid != null) {
            if (!this.uid.equals(other.uid)) {
                return false;
            }
        } else {
            if (this.id == null ? other.id != null : !this.id.equalsIgnoreCase(other.id)) {
                return false;
            }
            if (this.getApplicationEnvironment() == null ? other.getApplicationEnvironment() != null : !this.getApplicationEnvironment().equals(other.getApplicationEnvironment())) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName() + "[uid=" + this.uid + "]";
    }
}

